% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_tidyhydat_ECDE.R
\name{ch_tidyhydat_ECDE}
\alias{ch_tidyhydat_ECDE}
\title{Converts a tidyhydat daily flow data tibble to ECDE format}
\usage{
ch_tidyhydat_ECDE(data)
}
\arguments{
\item{data}{Tibble of daily flows retrieved using \pkg{tidyhydat} function \code{hy_daily_flows}.}
}
\value{
A dataframe or a list of flows with formats consistent with datafiles read using \code{ch_read_ECDE_flows}:
\item{ID}{stationID}
\item{PARAM}{Parameter 1 for Flow 2 for Level}
\item{Date}{Original charater string converted to date format}
\item{Flow}{Daily mean flow m\eqn{^3}{^3}/sec}
\item{SYM}{Quality flag}
}
\description{
Accessing daily flow data using \pkg{tidyhydat} is quick and efficient. However, it 
sometimes conflicts with other functions as \pkg{tidyhydat} changes variable names and some default 
entries. This function converts a tibble obtained from a \pkg{tidyhydat} tibble to a dataframe 
with standard Environment and Climate Change Canada Data Explorer (ECDE) names.
}
\examples{
# This example uses the built-in test database, by setting the hydat_path parameter
# You will want to use it with your actual HYDAT database
library(tidyhydat)
# check for existence of test database
test_db <- hy_test_db()
if (file.exists(test_db)) {
  hydat_path = hy_set_default_db(test_db)
  mdata <- hy_daily_flows(station_number=c("05AA008"))
  m_data <- ch_tidyhydat_ECDE(mdata)

  mdata <- hy_daily_flows(station_number=c("05AA008", "08MF005", "05HD008")) 
  mnew <- ch_tidyhydat_ECDE(mdata)
  str(mnew[[1]])
  str(mnew[[2]])
  str(mnew[[3]]) 
# note the order is in increasing alphabetical order
hy_set_default_db(NULL)    # Reset HYDAT database
}
}
\seealso{
\code{\link{ch_tidyhydat_ECDE_meta}}
}
\author{
Paul Whitfield
}
