% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_high_Grubbs_test.R
\name{ch_high_Grubbs_test}
\alias{ch_high_Grubbs_test}
\title{Grubbs test for high events}
\usage{
ch_high_Grubbs_test(amax)
}
\arguments{
\item{amax}{A vector of the annual maxima}
}
\value{
result A vector of the same length as amax with a 1 for those values
that are high outliers else zero.
}
\description{
Checks for outliers among the highest fifteen events, assumes the data are
normally distributed and uses the Grubbs test to determine if the highest
value is an outlier. If it is an outlier the next largest is tested until
the value is not an outlier, or 15 values have been tested.
}
\examples{
set.seed(1234)
x = rnorm(10)
x[11] <- 15
x[12] <- 35
ch_high_Grubbs_test(x)
}
\author{
Paul Whitfield
}
