#' @title Functions for Canadian hydrological analyses
#' @name CSHShydRology-package
#' 
#' @description \pkg{CSHShydRology} is intended for the use of hydrologists, particularly those in Canada. It will contain functions
#' which focus on the use of Canadian data sets, such as those from Environment Canada. The package will also contain functions which
#' are suited to Canadian hydrology, such as the important cold-region hydrological processes. \pkg{CSHShydRology} will also contain
#' functions which work with Canadian hydrological models, such as Raven, CRHM, Watflood, and MESH.
#' 
#' This package has been developed with the assistance of the Canadian Society for Hydrological Sciences (CSHS) \url{https://cshs.cwra.org/en/}
#' which is an affiliated society of the Canadian Water Resources Association (CWRA) \url{https://cwra.org/}.
#' 
#' The \pkg{CSHShydRology} will contain functions grouped into several themes, including:
#' \describe{
#' \item{Statistical hydrology}{trend detection, data screening, frequency analysis, regionalization}
#' \item{Basic data manipulations}{input/conversion/adapter functions, missing data infilling}
#' \item{Visualization}{data visualization, standardized plotting functions}
#' \item{Spatial hydrology}{basin delineation, landscape data analysis, working with GIS}
#' \item{Streamflow measurement analysis}{rating curve analysis, velocity profiles, naturalization}
#' \item{Network design/analysis}{homogeneity assessment}
#' \item{Ecohydrology}{fisheries and ecological analysis}
#' \item{Wrappers/unwrappers}{between other packages and \pkg{CSHShydRology}}
#'}
#' @references
#' To cite \pkg{CSHShydRology} in publications, use the command \code{citation("CSHShydRology")} 
#' to get the current version of this citation.\cr
#' 
#' @keywords package
"_PACKAGE"
