% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mouseset}
\alias{mouseset}
\title{Mouse}
\usage{
mouseset(
  n = 4000,
  r.head = 2,
  r.left.ear = 1.1,
  r.right.ear = 1.1,
  left.ear.dist = 2.5,
  right.ear.dist = 2.5,
  dim = 2
)
}
\arguments{
\item{n}{The number of points (default: 4000).}

\item{r.head}{The radius of the mouse's head (default: 2).}

\item{r.left.ear, r.right.ear}{The radii of the left and right ear of the 
mouse's head (default: 1.1).}

\item{left.ear.dist, right.ear.dist}{The distance between the center of the 
mouse's head and the center of the left and right ear (default: 2.5).}

\item{dim}{The dimensionality of the mouse's head (default: 2).}
}
\value{
A matrix with \code{n} rows and \code{dim} columns.
}
\description{
\code{mouseset} generates a cluster of points uniformly 
 distributed inside a "mouse head" shape.
}
\examples{
plot(mouseset())

}
