% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_stations.R
\name{create_stations}
\alias{create_stations}
\title{Create or load station metadata}
\usage{
create_stations(
  source = NULL,
  n = 10,
  bbox = c(-3.5, 1.5, 4.5, 11.5),
  seed = NULL
)
}
\arguments{
\item{source}{Path to CSV file OR a data.frame with Station/LON/LAT OR NULL (to generate synthetic).}

\item{n}{Integer number of stations to generate when source = NULL. Default 10.}

\item{bbox}{numeric vector c(min_lon, max_lon, min_lat, max_lat). Default ~ Ghana bounding box.}

\item{seed}{Optional numeric to make generation reproducible.}
}
\value{
A data.frame with columns Station, LON, LAT.
}
\description{
Create a station metadata table (Station, LON, LAT) either by:
\itemize{
\item loading from a CSV file,
\item accepting an existing data.frame,
\item or auto-generating synthetic stations in a bounding box.
}
}
\examples{
create_stations(n = 5, seed = 42)
create_stations(data.frame(Station="A", LON=0, LAT=5))
}
