% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{roc_bin_plot}
\alias{roc_bin_plot}
\title{ROC Plot Biomarkers Associated with Binary Outcomes}
\usage{
roc_bin_plot(
  yvar,
  xvars,
  dirs,
  data,
  yvar.display = yvar,
  xvars.display = xvars
)
}
\arguments{
\item{yvar}{Binary response variable name, where 0 represents controls and 1 represents cases.}

\item{xvars}{A vector of biomarker names.}

\item{dirs}{A vector of directions for the biomarkers. Options are "auto", ">", or "<".
- "auto" (default): automatically determines in which group the median is higher and takes the direction accordingly.
- ">" indicates that the biomarkers for the control group are higher than those for the case group (controls > t >= cases).
- "<" indicates that the biomarkers for the control group are lower or equal to those for the case group (controls < t <= cases).}

\item{data}{The dataset containing the variables.}

\item{yvar.display}{Display name for the binary response variable.}

\item{xvars.display}{Display names for the biomarkers.}
}
\value{
ROC plots for different biomarkers associated with binary outcomes.
}
\description{
Generates ROC plots for different biomarkers associated with binary outcomes.
}
\examples{
# Load a sample dataset
data <- data.frame(
  outcome = sample(c(0, 1), 100, replace = TRUE),
  biomarker1 = rnorm(100, mean = 0, sd = 1),
  biomarker2 = rnorm(100, mean = 5, sd = 2)
)

# Generate ROC plot for a single biomarker with auto direction
roc_bin_plot(
  yvar = "outcome",
  xvars = "biomarker1",
  dirs = "auto",
  data = data,
  yvar.display = "Binary Outcome",
  xvars.display = "Biomarker 1"
)

# Generate ROC plots for multiple biomarkers with specified directions
roc_bin_plot(
  yvar = "outcome",
  xvars = c("biomarker1", "biomarker2"),
  dirs = c("auto", "<"),
  data = data,
  yvar.display = "Binary Outcome",
  xvars.display = c("Biomarker 1", "Biomarker 2")
)
}
