% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{simulate_checkerboard}
\alias{simulate_checkerboard}
\title{Simulate checkerboard pattern}
\usage{
simulate_checkerboard(grid_size = 8, tile_size = 1)
}
\arguments{
\item{grid_size}{Number of tiles per row/column (default: 8)}

\item{tile_size}{Resolution of each tile in pixels per side (default: 1)}
}
\value{
Data frame with X, Y coordinates and signal_1, signal_2 patterns
}
\description{
Generate a checkerboard pattern with alternating signals
}
\examples{
\donttest{
# Generate 8x8 checkerboard with 10x10 pixel tiles
df <- simulate_checkerboard(grid_size = 8, tile_size = 10)
p <- visualize_checkerboard(df)
print(p)
}
}
