% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btsr.R
\docType{package}
\name{btsr-package}
\alias{BTSR-package}
\alias{btsr-package}
\alias{BTSR}
\alias{BTSR-Package}
\title{\packageTitle{BTSR}}
\description{
The BTSR package provides a unified framework for simulating, fitting, and
forecasting bounded time series regression models. It supports a wide
range of models, including i.i.d., regression, ARMA-like, and ARFIMA-like
models, with a focus on bounded time series data.

Key features of the BTSR package include
\itemize{
\item Simulation of bounded time series data using various models.
\item Estimation of model parameters using efficient algorithms.
\item Forecasting future values based on fitted models.
\item Support for both short-memory and long-memory models.
\item Flexible link functions and error scales.
}
}
\section{Mathematical Notation}{


The BTSR package is based on the following mathematical framework
\itemize{
\item \eqn{Y_t}: The bounded random variable at time \eqn{t}, with \eqn{Y_t
 \in (a, b)}.

\item \eqn{\mathcal{F}_t}: The \eqn{\sigma}-field generated by information
up to time \eqn{t}.

\item \eqn{\mu_t, \nu_t}: Parameters of the conditional distribution of
\eqn{Y_t}.

\item \eqn{\vartheta_t}: A transformation of \eqn{\nu_t} (e.g.,
\eqn{\vartheta_t = \nu_t^2}).

\item \eqn{\eta_{1t}, \eta_{2t}}: Linear predictors for \eqn{\mu_t} and
\eqn{\vartheta_t}, respectively.

\item \eqn{\phi, \theta}: Autoregressive (AR) and moving average (MA)
coefficients.

\item \eqn{d}: Fractional differencing parameter, controlling long-memory
behavior.

\item \eqn{e_{1t}, e_{2t}}: Error terms for each part of the model (see the
model definition for details).
}
}

\section{The BTSR Structure}{


Let \eqn{\{Y_t\}_{t\in \mathbb{Z}}} be a stochastic process for which
\eqn{Y_t \in (a, b)} with probability 1 (\eqn{a} and \eqn{b} not necessarily
finite), for all \eqn{t \in \mathbb{Z}}, and let \eqn{\mathcal{F}_{t}} denote
the \eqn{\sigma}-field generated by the information observed up to time
\eqn{t}. The general structure of a BTSR model is as follows

\deqn{
\begin{aligned}
Y_t | \mathcal{F}_{t-1} & \sim  f(\cdot |\mu_t, \nu_t), \quad \vartheta_t = g_2(\nu_t)\\
\eta_{1t} = g_{11}(\mu_t) & =\alpha_1 + \boldsymbol{X}_{1t}'\boldsymbol{\beta}_1 +
\sum_{i=1}^{p_1} \phi_{1i}[g_{12}(Y_{t-i})-I_{X_1}\boldsymbol{X}_{1(t-i)}'\boldsymbol{\beta}_1] +
\xi_t, \quad \text{(part 1)}\\
\eta_{2t} =  g_{21}(\vartheta_t) & =\alpha_2 + \boldsymbol{X}_{2t}' \boldsymbol{\beta}_2 +
\sum_{i=1}^{p_2}  \phi_{2i}[g_{22}(\vartheta_{t-i})-I_{X_2}\boldsymbol{X}_{2(t-i)}'\boldsymbol{\beta}_2] +
\sum_{k=1}^\infty c_{2k} e_{2,t-k},  \quad \text{(part 2)}
\end{aligned}
}

with \eqn{\xi_t} depending on the model, controlled by the argument \code{model},
\deqn{
\xi_t = \begin{cases}
h(T^{t-1}(U_0)), & \text{if } \code{model = "BARC"},\\
\sum_{k=1}^\infty c_{1k} e_{1,t-k}, & \text{otherwise},
\end{cases}
}

\eqn{e_{1,t}} depending on the \code{error.scale} adopted
\deqn{
e_{1,t} = g_{13}(Y_t, \mu_t) = \begin{cases}
Y_t - \mu_t, & \text{if } \code{error.scale = 0} \text{ (data scale)},\\
g_{11}(Y_t) - g_{11}(\mu_t), & \text{if } \code{error.scale = 1} \text{ (predictive scale)}
\end{cases}
}
and \eqn{e_{2,t} = g_{23}(e_{1,t})}, where
\itemize{
\item \eqn{I_{X_1}}, \eqn{I_{X_2}} are indicator functions, which control
whether the regressors should be included in the AR part of the equation.
These functions are controlled by the argument \code{xregar} as follows:
\code{xregar = FALSE} corresponds to \eqn{I_{X} = 0} and \code{xregar = TRUE}
corresponds to \eqn{I_{X} = 1}. If \code{xregar = FALSE}, the corresponding
argument \code{xreg} is not included in the AR part of the model.

\item \eqn{g_{13}} is a function of \eqn{Y_t} and \eqn{\mu_t}, defined by
the error scale adopted.

\item \eqn{g_2} and \eqn{g_{ij}}, \eqn{i,j \in \{1,2\}}, and \eqn{g_{23}}
are link functions defined in the argument \code{linkg}. Notice that the links
\eqn{g_{ij}} are only used in the AR part of the model and, typically,
\eqn{g_{i1} = g_{i2}} for each \eqn{i \in \{1,2\}}. The link \eqn{g_2} might
depend on the distribution adopted. Finally, \eqn{g_{23}} is a link function
that transforms the error term \eqn{e_{1t}}.

\item \eqn{h} is the link function for BARC models, defined in the argument
\code{linkh}.

\item \eqn{\{c_{ik}\}_{k \geq 1}} are the coefficients obtained through the
relation
\deqn{
  \theta_i(z) = \sum_{k = 0}^{q_i} \theta_{ik}z^k
  \quad \text{and} \quad
  (1-L)^{-d_i}\theta_i(z) = \sum_{k = 0}^\infty c_{ik}z^k, \quad i \in \{1,2\}.
}
In particular, if \eqn{d_i = 0}, then \eqn{c_{ik} = \theta_{ik}}, for \eqn{k
= 1, \dots, q_i}.
}
}

\examples{
#----------------------------
# Quickstart examples.
#----------------------------

# Example 1: Simulate i.i.d. samples
set.seed(1234)
y1 <- btsr.sim(model = "BETA", n = 1000, coefs = list(alpha = 0.2, nu = 20))
hist(y1)

# Example 2: Simulate ARMA-like model with fixed nu
y2 <- btsr.sim(
  model = "BARMA", n = 100, link = "logit",
  coefs = list(alpha = 0.2, phi = 0.5, theta = 0.3, nu = 20)
)
plot(y2, type = "l")

}
\references{
\insertRef{bayer2017}{BTSR}

\insertRef{pumi2019}{BTSR}

\insertRef{pumi2021}{BTSR}

\insertRef{pumi2024uw}{BTSR}

\insertRef{pumi2024uwc}{BTSR}

\insertRef{pumi2025ul}{BTSR}

\insertRef{pumi2025matsu}{BTSR}

\insertRef{prass2025}{BTSR}
}
\seealso{
For detailed examples and usage instructions, see the documentation for
individual functions
\itemize{
\item \link{btsr.sim}: Simulate bounded time series data.

\item \link{btsr.extract}: Extract components of a BTSR model, for a given set of
parameters

\item \link{btsr.fit}: Fit a BTSR model to data.

\item \link{predict}: Forecast future values using a fitted model.

\item \link{arguments}: Shared documentation for arguments
}
}
\author{
Taiane Schaedler Prass \email{taianeprass@gmail.com},
Guilherme Pumi \email{guipumi@gmail.com}
}
\keyword{distribution}
\keyword{package}
\keyword{regression}
