% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R
\name{arguments.coefs}
\alias{arguments.coefs}
\title{Shared documentation for coefficients}
\arguments{
\item{ignore.start}{optional; logical value indicating whether the argument
\code{start} should be ignored (fit only). If starting values are not provided,
the function uses the default values and \code{ignore.start} is ignored. In case
starting values are provided and \code{ignore.start = TRUE}, those starting
values are ignored and recalculated. The default is \code{ignore.start = FALSE}.
Partial starting values are not allowed.}

\item{start}{optional; a list with the starting values for the non-fixed
coefficients of the model (fit only). The default is \code{start = NULL}, in
which case the function \link{coefs.start} is used internally to obtain starting
values for the parameters. For details on the expected format and the
arguments that can be passed through  \code{coefs}, see the Section \link[=arguments.coefs]{Model coefficients}.}

\item{coefs}{a list with the coefficients of the model (simulation and
extraction only). The default is \code{coefs = NULL}. For details on the
expected format and the arguments that can be passed through \code{coefs}, see
the Section \link[=arguments.coefs]{Model coefficients}.}

\item{lags}{optional; a list with the lags (integer values) that the entries
in \code{coefs} or \code{start} correspond to (extract and fit only). The default is
\code{lags = NULL}, in which the \code{lags} are computed from the \code{fixed.lags}
argument (if provided). When components are missing or empty in both,
\code{lags} and \code{fixed.lags}, the default behavior is to include all lags based
on \code{nreg = ncol(xreg)}, \code{p}, and \code{q}. For details, see the Section \link[=arguments.coefs]{Model coefficients}.}

\item{fixed.values}{optional; a list with the values of the coefficients that
are fixed (extract and fit only). The default is \code{fixed.values = NULL}. See
the Section \link[=arguments.coefs]{Model coefficients}.}

\item{fixed.lags}{optional; a list with the lags (integer values) that the
fixed values in \code{fixed.values} correspond to (extract and fit only). The
default is \code{fixed.lags = NULL}. For missing components, fixed values will
are set based on \code{lags}.}

\item{lower}{optional; list with the lower bounds for the parameters (fit
only). Default is \code{lower = NULL}. The default is to assume that the
parameters have no lower bound except for \code{nu}, for which de default is 0.
Only the bounds for bounded parameters need to be specified. The format of
\code{lower} and the arguments that can be passed through this list are the same
as the ones for \code{start}.}

\item{upper}{optional; list with the upper bounds for the parameters (fit
only). Default is \code{upper = NULL}. The default is to assume that the
parameters have no upper bound. Only the bounds for bounded parameters need
to be specified. The format of \code{lower} and the arguments that can be passed
through this list are the same as the ones for \code{start}.}
}
\description{
This is the common documentation for arguments related to the coefficients in
BTSR models.
}
\section{Model coefficients}{
\code{start}, \code{coefs}, \code{fixed.values}, \code{lags} and \code{fixed.lags} can be specified in
one of two ways
\itemize{
\item \strong{Legacy structure:} a list with optional components \code{alpha},
\code{beta}, \code{phi}, \code{theta}, \code{d}, \code{u0} (BARC only) and required argument \code{nu}
(except for one-parameter models such as ULARMA and MARMA).

\item \strong{New structure:} a list with elements \code{part1} and \code{part2}, each
being a list with with optional components \code{alpha}, \code{beta}, \code{phi}, \code{theta},
\code{d} and  \code{u0} (BARC only).
}

The optional arguments in this lists are
\itemize{
\item \code{alpha}: a numeric value corresponding to the intercept. For i.i.d.
corresponds to the mean of the distribution.

\item \code{beta}: a vector of coefficients corresponding to the regressors in
\code{xreg}.

\item \code{phi}: a vector of autoregressive coefficients.

\item \code{theta}: for BARC models, this is the parameter for the map function
(see \link{BARC.functions} for details). For any other model, this is a vector
of moving average coefficients corresponding to the MA order.

\item\code{d}: a numeric value corresponding to the long memory parameter.

\item \code{u0}: a numeric value in the interval \eqn{(0,1)}, corresponding to
the value of the random variable \eqn{U_0}. See \link{BARC.functions} for
details.

\item\code{nu}: distribution related parameter, usually the dispersion.
}

The following rules apply for these lists and their arguments.\cr

\emph{Simulation:}
\itemize{
\item Passing \code{coefs} as an empty list will result in an error message.

\item \code{start} and \code{fixed.values} (consequently, \code{fixed.lags}) are not used.

\item If \code{xreg} is provided but \code{coefs} does not include a \code{beta} argument,
an error message is issued.

\item \code{phi} must be a vector of length \eqn{p} (the AR order), meaning all
coefficients must be provided, including zeros.

\item \code{theta} (non-BARC models) must be a vector of length \eqn{q} (the MA
order), meaning all coefficients must be provided, including zeros.
}

\emph{Extraction:}
\itemize{
\item One dimensional parameters (e.g. \code{alpha}) that do not appear in
\code{coefs} are assume to be fixed.

\item An error message will be issued if both \code{coefs} and \code{fixed.values} are
both empty.

\item If \eqn{\nu} is not constant over time and \code{nu} is missing in both
\code{coefs} and \code{fixed.values}, an error message is issued (except for
one-parameter models such as ULARMA and MARMA). Ignored if the new format
is used.
}

\emph{Fitting:}
\itemize{
\item One dimensional parameters (e.g. \code{alpha}) cannot appear in both
\code{start} and \code{fixed.values}.

\item \code{coefs} is not used.
}

\emph{Extraction and fitting:}
\itemize{
\item Coefficients may include both fixed lags (with values in
\code{fixed.values}) and non-fixed lags (with values in \code{coefs} or \code{start}).

\item \code{lags} and \code{fixed.lags} are complementary. Either suffices, or mix
them (e.g., \code{lags} for some parameters, \code{fixed.lags} for others).

\item For one dimensional parameters, the lag is obviously always 1 and can
be suppressed when the parameter added to the \code{fixed.values} list.

\item For extraction, if \code{coefs = NULL}, one dimensional parameters that do
not appear in \code{fixed.values} are assumed to be non-fixed. The same goes for
fitting when \code{start = NULL} or \code{ignore.start = TRUE}.

\item If \code{coefs}/\code{start} is provided, one dimensional parameters that do not
appear in this list are assumed to be fixed.

\item By default, if a given vector has fixed lags and the corresponding
entry in \code{fixed.values} is empty, the fixed values are set as zero.

\item If parameter values are provided in \code{coefs}, \code{start} or \code{fixed.values}
and the size of the vector is not the same as the dimension of the
parameters, either \code{lags} or \code{fixed.lags} must also be provided.
}
}

