% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fourier_bases.R
\name{plot_fourier_bases}
\alias{plot_fourier_bases}
\title{Visualize fourier bases.}
\usage{
plot_fourier_bases(
  coords,
  R = 6,
  fine = 100,
  plot.3d = FALSE,
  freq.lon = diff(range(coords[, 1])),
  freq.lat = diff(range(coords[, 2])),
  par.mfrow = c(2, 3)
)
}
\arguments{
\item{coords}{A matrix of coordinates of observed locations.}

\item{R}{Integer indicating the number of bases to compute.}

\item{fine}{Number of grid points to include on both axes.  Total grid size will be \code{fine^2}.  Default is \code{100}.}

\item{plot.3d}{Logical scalar indicating whether to plot the bases.  Default is \code{FALSE}.}

\item{freq.lon}{Numeric value indicating the frequency to use for the Fourier bases in the longitude direction.  Default is \code{diff(range(coords[,1]))}.}

\item{freq.lat}{Numeric value indicating the frequency to use for the Fourier bases in the latitude direction.  Default is \code{diff(range(coords[,2]))}.}

\item{par.mfrow}{If \code{plot.3d=TRUE}, how to divide the plotting window. See \code{help(par)} for more details.}
}
\value{
A plot of the Fourier bases for a given frequency.
}
\description{
Visualize fourier bases.
}
\author{
Adam Simpson
}
