% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bss_accumulated_volatility.R
\name{estimateAccumulatedVolatility}
\alias{estimateAccumulatedVolatility}
\title{Estimate accumulated volatility processes}
\usage{
estimateAccumulatedVolatility(
  Y,
  n,
  p = 2,
  method = "nonparametric",
  kernel = "gamma"
)
}
\arguments{
\item{Y}{a vector of observations of a BSS process.}

\item{n}{positive integer indicating the number of observations per unit of time.}

\item{p}{the power to evaluate the accumulated power volatility process for. Defaults to 2, in order to
estimate the accumulated squared volatility process.}

\item{method}{text string representing the method used to estimate the accumulated volatility. Options are \code{'acf'}, \code{'cof'}
or \code{nonparametric}. If \code{'acf'} is selected, model parameters are fit to the data \code{Y} using
least squares on the autocorrelation function and these parameters are used to estimate the scale factor.
If \code{'cof'} is selected, only the smoothness parameter \code{alpha} is estimated using the change of frequency
method, and then put into an asymptotic expression for the scale factor in the calculation. If \code{'nonparametric'}
is selected then the non-parametric estimator for the scale factor will be used in the calculation. Defaults to \code{'nonparametric'}.}

\item{kernel}{text string representing the choice of kernel when fitting the model to estimate
the scale factor parametrically. Options are \code{'gamma'} and \code{'power'}. Defaults to \code{'gamma'}.}
}
\value{
The function returns a vector of the same length as \code{Y} which is the estimate for the
accumulated volatility process, observed from time 0 to T, at intervals of T/n. Note that the values have been
divided by m_p in the output, so that the estimation is of the integral alone. If the non-parametric
estimator for tau_n is used then the values will be scaled by the expectation of the squared volatility, as
per the theory.
}
\description{
\code{estimateAccumulatedVolatility} estimates the pth power accumulated volatility process for a Brownian
semistationary process, using either parametric methods of model fitting first, or using a non-parametric
estimator for the scale factor.
}
\examples{

N <- 10000
n <- 100
T <- 1.0
theta <- 0.5
beta <- 0.125

kappa <- 3
alpha <- -0.2
lambda <- 1.0


vol <- exponentiatedOrnsteinUhlenbeck(N, n, T, theta, beta)
bss_simulation <- gammaKernelBSS(N, n, T, kappa, alpha, lambda, sigma = vol)
y <- bss_simulation$bss
estimateAccumulatedVolatility(y, n, p = 2, method = 'nonparametric', kernel = 'gamma')

#'

}
