% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpGeneric.R
\name{resample}
\alias{resample}
\title{Resample Elements of a Vector}
\usage{
resample(x, ...)
}
\arguments{
\item{x}{A vector containing the elements to be resampled. If `x` is empty, the
function will return `NA_integer_`.}

\item{...}{Additional arguments passed to `sample.int`, such as `size` for the
number of items to sample and `replace` indicating whether sampling should be with
replacement.}
}
\value{
A vector of resampled elements from `x`. If `x` is empty, returns
`NA_integer_`. The length and type of the returned vector depend on the input
vector `x` and the additional arguments provided via `...`.
}
\description{
This function performs resampling of the elements in a vector `x`. It randomly
shuffles the elements of `x` and returns a vector of the resampled elements. If `x`
is empty, it returns `NA_integer_`.
}
\keyword{internal}
