% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Survival.R
\name{AutoScore_fine_tuning_Survival}
\alias{AutoScore_fine_tuning_Survival}
\title{AutoScore STEP(iv) for survival outcomes: Fine-tune the score by
  revising cut_vec with domain knowledge (AutoScore Module 5)}
\usage{
AutoScore_fine_tuning_Survival(
  train_set,
  validation_set,
  final_variables,
  cut_vec,
  max_score = 100,
  time_point = c(1, 3, 7, 14, 30, 60, 90)
)
}
\arguments{
\item{train_set}{A processed \code{data.frame} that contains data to be analyzed, for training.}

\item{validation_set}{A processed \code{data.frame} that contains data for validation purpose.}

\item{final_variables}{A vector containing the list of selected variables, selected from Step(ii) \code{\link{AutoScore_parsimony}}. Run \code{vignette("Guide_book", package = "AutoScore")} to see the guidebook or vignette.}

\item{cut_vec}{Generated from STEP(iii)
\code{AutoScore_weighting_Survival()}.Please follow the guidebook}

\item{max_score}{Maximum total score (Default: 100).}

\item{time_point}{The time points to be evaluated using time-dependent AUC(t).}
}
\value{
Generated final table of scoring model for downstream testing
}
\description{
Domain knowledge is essential in guiding risk model development.
 For continuous variables, the variable transformation is a data-driven process (based on "quantile" or "kmeans" ).
 In this step, the automatically generated cutoff values for each continuous variable can be fine-tuned
 by combining, rounding, and adjusting according to the standard clinical norm.  Revised \code{cut_vec} will be input with domain knowledge to
update scoring table. User can choose any cut-off values/any number of categories. Then final Scoring table will be generated. Run \code{vignette("Guide_book", package = "AutoScore")} to see the guidebook or vignette.
}
\examples{
## Please see the guidebook or vignettes
}
\references{
\itemize{
 \item{Xie F, Ning Y, Yuan H, et al. AutoScore-Survival: Developing
 interpretable machine learning-based time-to-event scores with right-censored
 survival data. J Biomed Inform. 2022;125:103959. doi:10.1016/j.jbi.2021.103959}
}
}
\seealso{
\code{\link{AutoScore_rank_Survival}},
  \code{\link{AutoScore_parsimony_Survival}},
  \code{\link{AutoScore_weighting_Survival}},
  \code{\link{AutoScore_testing_Survival}}.
}
