

















use crate::{
    use_file,
    util_libc::{sys_fill_exact, Weak},
    Error,
};
use core::mem::{self, MaybeUninit};

static GETRANDOM: Weak = unsafe { Weak::new("getrandom\0") };
type GetRandomFn =
    unsafe extern "C" fn(*mut libc::c_void, libc::size_t, libc::c_uint) -> libc::ssize_t;

pub fn getrandom_inner(dest: &mut [MaybeUninit<u8>]) -> Result<(), Error> {
    if let Some(fptr) = GETRANDOM.ptr() {
        let func: GetRandomFn = unsafe { mem::transmute(fptr) };


        for chunk in dest.chunks_mut(256) {
            sys_fill_exact(chunk, |buf| unsafe {

                func(
                    buf.as_mut_ptr() as *mut libc::c_void,
                    buf.len(),
                    libc::GRND_RANDOM as libc::c_uint,
                )
            })?
        }
        Ok(())
    } else {
        use_file::getrandom_inner(dest)
    }
}
