// Generated by rstantools.  Do not edit by hand.

/*
    zoid is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    zoid is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with zoid.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_dirichregmod_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'dirichregmod', line 54, column 2 to column 36)",
                                                      " (in 'dirichregmod', line 55, column 2 to column 36)",
                                                      " (in 'dirichregmod', line 58, column 2 to column 20)",
                                                      " (in 'dirichregmod', line 59, column 2 to column 52)",
                                                      " (in 'dirichregmod', line 60, column 2 to column 51)",
                                                      " (in 'dirichregmod', line 61, column 2 to column 30)",
                                                      " (in 'dirichregmod', line 62, column 2 to column 47)",
                                                      " (in 'dirichregmod', line 64, column 2 to column 10)",
                                                      " (in 'dirichregmod', line 65, column 19 to column 38)",
                                                      " (in 'dirichregmod', line 65, column 18 to column 39)",
                                                      " (in 'dirichregmod', line 65, column 2 to column 39)",
                                                      " (in 'dirichregmod', line 67, column 4 to column 25)",
                                                      " (in 'dirichregmod', line 66, column 23 to line 68, column 3)",
                                                      " (in 'dirichregmod', line 66, column 2 to line 68, column 3)",
                                                      " (in 'dirichregmod', line 71, column 6 to column 32)",
                                                      " (in 'dirichregmod', line 70, column 25 to line 72, column 5)",
                                                      " (in 'dirichregmod', line 70, column 4 to line 72, column 5)",
                                                      " (in 'dirichregmod', line 69, column 26 to line 73, column 3)",
                                                      " (in 'dirichregmod', line 69, column 2 to line 73, column 3)",
                                                      " (in 'dirichregmod', line 76, column 11 to column 17)",
                                                      " (in 'dirichregmod', line 76, column 4 to column 26)",
                                                      " (in 'dirichregmod', line 78, column 6 to column 53)",
                                                      " (in 'dirichregmod', line 77, column 23 to line 79, column 5)",
                                                      " (in 'dirichregmod', line 77, column 4 to line 79, column 5)",
                                                      " (in 'dirichregmod', line 80, column 4 to column 29)",
                                                      " (in 'dirichregmod', line 82, column 6 to column 26)",
                                                      " (in 'dirichregmod', line 81, column 23 to line 83, column 5)",
                                                      " (in 'dirichregmod', line 81, column 4 to line 83, column 5)",
                                                      " (in 'dirichregmod', line 75, column 25 to line 84, column 3)",
                                                      " (in 'dirichregmod', line 75, column 2 to line 84, column 3)",
                                                      " (in 'dirichregmod', line 87, column 6 to column 45)",
                                                      " (in 'dirichregmod', line 86, column 23 to line 90, column 5)",
                                                      " (in 'dirichregmod', line 86, column 4 to line 90, column 5)",
                                                      " (in 'dirichregmod', line 93, column 6 to column 70)",
                                                      " (in 'dirichregmod', line 92, column 23 to line 94, column 5)",
                                                      " (in 'dirichregmod', line 92, column 4 to line 94, column 5)",
                                                      " (in 'dirichregmod', line 85, column 24 to line 95, column 3)",
                                                      " (in 'dirichregmod', line 85, column 2 to line 95, column 3)",
                                                      " (in 'dirichregmod', line 123, column 2 to column 18)",
                                                      " (in 'dirichregmod', line 124, column 2 to column 17)",
                                                      " (in 'dirichregmod', line 125, column 2 to column 42)",
                                                      " (in 'dirichregmod', line 126, column 2 to column 57)",
                                                      " (in 'dirichregmod', line 127, column 2 to column 61)",
                                                      " (in 'dirichregmod', line 128, column 2 to column 60)",
                                                      " (in 'dirichregmod', line 129, column 2 to column 25)",
                                                      " (in 'dirichregmod', line 132, column 6 to column 23)",
                                                      " (in 'dirichregmod', line 133, column 6 to column 64)",
                                                      " (in 'dirichregmod', line 135, column 8 to column 40)",
                                                      " (in 'dirichregmod', line 136, column 8 to column 43)",
                                                      " (in 'dirichregmod', line 137, column 8 to column 181)",
                                                      " (in 'dirichregmod', line 134, column 32 to line 138, column 7)",
                                                      " (in 'dirichregmod', line 134, column 6 to line 138, column 7)",
                                                      " (in 'dirichregmod', line 141, column 8 to column 55)",
                                                      " (in 'dirichregmod', line 142, column 33 to column 49)",
                                                      " (in 'dirichregmod', line 142, column 8 to column 49)",
                                                      " (in 'dirichregmod', line 143, column 8 to column 53)",
                                                      " (in 'dirichregmod', line 144, column 32 to column 48)",
                                                      " (in 'dirichregmod', line 144, column 8 to column 48)",
                                                      " (in 'dirichregmod', line 145, column 8 to column 66)",
                                                      " (in 'dirichregmod', line 147, column 10 to column 38)",
                                                      " (in 'dirichregmod', line 148, column 10 to column 41)",
                                                      " (in 'dirichregmod', line 149, column 10 to column 54)",
                                                      " (in 'dirichregmod', line 150, column 10 to column 39)",
                                                      " (in 'dirichregmod', line 146, column 34 to line 151, column 9)",
                                                      " (in 'dirichregmod', line 146, column 8 to line 151, column 9)",
                                                      " (in 'dirichregmod', line 140, column 22 to line 152, column 7)",
                                                      " (in 'dirichregmod', line 140, column 6 to line 152, column 7)",
                                                      " (in 'dirichregmod', line 131, column 23 to line 153, column 5)",
                                                      " (in 'dirichregmod', line 131, column 4 to line 153, column 5)",
                                                      " (in 'dirichregmod', line 130, column 24 to line 154, column 3)",
                                                      " (in 'dirichregmod', line 130, column 2 to line 154, column 3)",
                                                      " (in 'dirichregmod', line 98, column 2 to column 18)",
                                                      " (in 'dirichregmod', line 99, column 2 to column 17)",
                                                      " (in 'dirichregmod', line 101, column 4 to column 26)",
                                                      " (in 'dirichregmod', line 100, column 18 to line 102, column 3)",
                                                      " (in 'dirichregmod', line 100, column 2 to line 102, column 3)",
                                                      " (in 'dirichregmod', line 106, column 6 to column 41)",
                                                      " (in 'dirichregmod', line 105, column 27 to line 107, column 5)",
                                                      " (in 'dirichregmod', line 105, column 4 to line 107, column 5)",
                                                      " (in 'dirichregmod', line 104, column 22 to line 108, column 3)",
                                                      " (in 'dirichregmod', line 104, column 2 to line 108, column 3)",
                                                      " (in 'dirichregmod', line 112, column 6 to column 58)",
                                                      " (in 'dirichregmod', line 114, column 8 to column 40)",
                                                      " (in 'dirichregmod', line 115, column 8 to column 43)",
                                                      " (in 'dirichregmod', line 117, column 8 to column 175)",
                                                      " (in 'dirichregmod', line 113, column 32 to line 118, column 7)",
                                                      " (in 'dirichregmod', line 113, column 6 to line 118, column 7)",
                                                      " (in 'dirichregmod', line 110, column 23 to line 119, column 5)",
                                                      " (in 'dirichregmod', line 110, column 4 to line 119, column 5)",
                                                      " (in 'dirichregmod', line 109, column 24 to line 120, column 3)",
                                                      " (in 'dirichregmod', line 109, column 2 to line 120, column 3)",
                                                      " (in 'dirichregmod', line 2, column 2 to column 16)",
                                                      " (in 'dirichregmod', line 3, column 2 to column 13)",
                                                      " (in 'dirichregmod', line 4, column 9 to column 18)",
                                                      " (in 'dirichregmod', line 4, column 20 to column 26)",
                                                      " (in 'dirichregmod', line 4, column 2 to column 30)",
                                                      " (in 'dirichregmod', line 5, column 2 to column 14)",
                                                      " (in 'dirichregmod', line 6, column 9 to column 18)",
                                                      " (in 'dirichregmod', line 6, column 20 to column 27)",
                                                      " (in 'dirichregmod', line 6, column 2 to column 38)",
                                                      " (in 'dirichregmod', line 7, column 8 to column 14)",
                                                      " (in 'dirichregmod', line 7, column 15 to column 23)",
                                                      " (in 'dirichregmod', line 7, column 2 to column 38)",
                                                      " (in 'dirichregmod', line 8, column 2 to column 15)",
                                                      " (in 'dirichregmod', line 9, column 2 to column 15)",
                                                      " (in 'dirichregmod', line 10, column 2 to column 16)",
                                                      " (in 'dirichregmod', line 13, column 8 to column 17)",
                                                      " (in 'dirichregmod', line 13, column 18 to column 24)",
                                                      " (in 'dirichregmod', line 13, column 2 to column 38)",
                                                      " (in 'dirichregmod', line 15, column 8 to column 17)",
                                                      " (in 'dirichregmod', line 15, column 18 to column 24)",
                                                      " (in 'dirichregmod', line 15, column 2 to column 44)",
                                                      " (in 'dirichregmod', line 16, column 9 to column 18)",
                                                      " (in 'dirichregmod', line 16, column 20 to column 26)",
                                                      " (in 'dirichregmod', line 16, column 2 to column 33)",
                                                      " (in 'dirichregmod', line 17, column 9 to column 18)",
                                                      " (in 'dirichregmod', line 17, column 20 to column 26)",
                                                      " (in 'dirichregmod', line 17, column 2 to column 34)",
                                                      " (in 'dirichregmod', line 18, column 9 to column 18)",
                                                      " (in 'dirichregmod', line 18, column 2 to column 24)",
                                                      " (in 'dirichregmod', line 19, column 9 to column 15)",
                                                      " (in 'dirichregmod', line 19, column 2 to column 22)",
                                                      " (in 'dirichregmod', line 22, column 4 to column 16)",
                                                      " (in 'dirichregmod', line 21, column 21 to line 23, column 3)",
                                                      " (in 'dirichregmod', line 21, column 2 to line 23, column 3)",
                                                      " (in 'dirichregmod', line 26, column 4 to column 15)",
                                                      " (in 'dirichregmod', line 28, column 6 to column 31)",
                                                      " (in 'dirichregmod', line 27, column 23 to line 29, column 5)",
                                                      " (in 'dirichregmod', line 27, column 4 to line 29, column 5)",
                                                      " (in 'dirichregmod', line 25, column 24 to line 30, column 3)",
                                                      " (in 'dirichregmod', line 25, column 2 to line 30, column 3)",
                                                      " (in 'dirichregmod', line 36, column 8 to column 25)",
                                                      " (in 'dirichregmod', line 35, column 13 to line 37, column 7)",
                                                      " (in 'dirichregmod', line 34, column 8 to column 25)",
                                                      " (in 'dirichregmod', line 33, column 20 to line 35, column 7)",
                                                      " (in 'dirichregmod', line 33, column 6 to line 37, column 7)",
                                                      " (in 'dirichregmod', line 39, column 8 to column 31)",
                                                      " (in 'dirichregmod', line 38, column 40 to line 40, column 7)",
                                                      " (in 'dirichregmod', line 38, column 6 to line 40, column 7)",
                                                      " (in 'dirichregmod', line 32, column 23 to line 41, column 5)",
                                                      " (in 'dirichregmod', line 32, column 4 to line 41, column 5)",
                                                      " (in 'dirichregmod', line 31, column 24 to line 42, column 3)",
                                                      " (in 'dirichregmod', line 31, column 2 to line 42, column 3)",
                                                      " (in 'dirichregmod', line 47, column 10 to column 34)",
                                                      " (in 'dirichregmod', line 48, column 10 to column 44)",
                                                      " (in 'dirichregmod', line 46, column 34 to line 49, column 9)",
                                                      " (in 'dirichregmod', line 46, column 8 to line 49, column 9)",
                                                      " (in 'dirichregmod', line 45, column 25 to line 50, column 7)",
                                                      " (in 'dirichregmod', line 45, column 6 to line 50, column 7)",
                                                      " (in 'dirichregmod', line 44, column 26 to line 51, column 5)",
                                                      " (in 'dirichregmod', line 44, column 4 to line 51, column 5)",
                                                      " (in 'dirichregmod', line 54, column 18 to column 26)",
                                                      " (in 'dirichregmod', line 55, column 9 to column 17)",
                                                      " (in 'dirichregmod', line 55, column 18 to column 25)",
                                                      " (in 'dirichregmod', line 59, column 26 to column 35)",
                                                      " (in 'dirichregmod', line 59, column 37 to column 43)",
                                                      " (in 'dirichregmod', line 60, column 26 to column 35)",
                                                      " (in 'dirichregmod', line 60, column 37 to column 43)",
                                                      " (in 'dirichregmod', line 61, column 9 to column 15)",
                                                      " (in 'dirichregmod', line 61, column 16 to column 23)",
                                                      " (in 'dirichregmod', line 62, column 26 to column 35)",
                                                      " (in 'dirichregmod', line 62, column 36 to column 42)",
                                                      " (in 'dirichregmod', line 125, column 8 to column 17)",
                                                      " (in 'dirichregmod', line 125, column 26 to column 32)",
                                                      " (in 'dirichregmod', line 126, column 8 to column 26)",
                                                      " (in 'dirichregmod', line 126, column 35 to column 50)",
                                                      " (in 'dirichregmod', line 127, column 8 to column 26)",
                                                      " (in 'dirichregmod', line 127, column 27 to column 42)",
                                                      " (in 'dirichregmod', line 128, column 8 to column 26)",
                                                      " (in 'dirichregmod', line 128, column 27 to column 42)"};
#include <stan_meta_header.hpp>
class model_dirichregmod final : public model_base_crtp<model_dirichregmod> {
private:
  int N_samples;
  int N_bins;
  Eigen::Matrix<double, -1, -1> X;
  int N_covar;
  Eigen::Matrix<double, -1, -1> design_X;
  std::vector<std::vector<int>> prod_idx;
  int overdisp;
  int postpred;
  double prior_sd;
  std::vector<std::vector<int>> is_zero;
  std::vector<std::vector<int>> is_proportion;
  Eigen::Matrix<double, -1, -1> logX;
  Eigen::Matrix<double, -1, -1> logNX;
  Eigen::Matrix<double, -1, 1> ESS;
  Eigen::Matrix<double, -1, 1> ones;
  int beta_raw_1dim__;
  int ynew_1dim__;
  int ynew_2dim__;
  int newy_is_zero_1dim__;
  int newy_is_zero_2dim__;
  int newy_is_one_1dim__;
  int newy_is_one_2dim__;
 
public:
  ~model_dirichregmod() { }
  
  inline std::string model_name() const final { return "model_dirichregmod"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_dirichregmod(stan::io::var_context& context__,
                     unsigned int random_seed__ = 0,
                     std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_dirichregmod_namespace::model_dirichregmod";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 92;
      context__.validate_dims("data initialization","N_samples","int",
          context__.to_vec());
      N_samples = std::numeric_limits<int>::min();
      
      current_statement__ = 92;
      N_samples = context__.vals_i("N_samples")[(1 - 1)];
      current_statement__ = 93;
      context__.validate_dims("data initialization","N_bins","int",
          context__.to_vec());
      N_bins = std::numeric_limits<int>::min();
      
      current_statement__ = 93;
      N_bins = context__.vals_i("N_bins")[(1 - 1)];
      current_statement__ = 94;
      validate_non_negative_index("X", "N_samples", N_samples);
      current_statement__ = 95;
      validate_non_negative_index("X", "N_bins", N_bins);
      current_statement__ = 96;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N_samples, N_bins));
      X = Eigen::Matrix<double, -1, -1>(N_samples, N_bins);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 96;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 96;
        pos__ = 1;
        current_statement__ = 96;
        for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
          current_statement__ = 96;
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            current_statement__ = 96;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 96;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 97;
      context__.validate_dims("data initialization","N_covar","int",
          context__.to_vec());
      N_covar = std::numeric_limits<int>::min();
      
      current_statement__ = 97;
      N_covar = context__.vals_i("N_covar")[(1 - 1)];
      current_statement__ = 98;
      validate_non_negative_index("design_X", "N_samples", N_samples);
      current_statement__ = 99;
      validate_non_negative_index("design_X", "N_covar", N_covar);
      current_statement__ = 100;
      context__.validate_dims("data initialization","design_X","double",
          context__.to_vec(N_samples, N_covar));
      design_X = Eigen::Matrix<double, -1, -1>(N_samples, N_covar);
      stan::math::fill(design_X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> design_X_flat__;
        current_statement__ = 100;
        assign(design_X_flat__, nil_index_list(),
          context__.vals_r("design_X"), "assigning variable design_X_flat__");
        current_statement__ = 100;
        pos__ = 1;
        current_statement__ = 100;
        for (int sym1__ = 1; sym1__ <= N_covar; ++sym1__) {
          current_statement__ = 100;
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            current_statement__ = 100;
            assign(design_X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              design_X_flat__[(pos__ - 1)], "assigning variable design_X");
            current_statement__ = 100;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 101;
      validate_non_negative_index("prod_idx", "N_bins", N_bins);
      current_statement__ = 102;
      validate_non_negative_index("prod_idx", "N_bins - 1", (N_bins - 1));
      current_statement__ = 103;
      context__.validate_dims("data initialization","prod_idx","int",
          context__.to_vec(N_bins, (N_bins - 1)));
      prod_idx = std::vector<std::vector<int>>(N_bins, std::vector<int>(
        (N_bins - 1), std::numeric_limits<int>::min()));
      
      {
        std::vector<int> prod_idx_flat__;
        current_statement__ = 103;
        assign(prod_idx_flat__, nil_index_list(),
          context__.vals_i("prod_idx"), "assigning variable prod_idx_flat__");
        current_statement__ = 103;
        pos__ = 1;
        current_statement__ = 103;
        for (int sym1__ = 1; sym1__ <= (N_bins - 1); ++sym1__) {
          current_statement__ = 103;
          for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
            current_statement__ = 103;
            assign(prod_idx,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              prod_idx_flat__[(pos__ - 1)], "assigning variable prod_idx");
            current_statement__ = 103;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 104;
      context__.validate_dims("data initialization","overdisp","int",
          context__.to_vec());
      overdisp = std::numeric_limits<int>::min();
      
      current_statement__ = 104;
      overdisp = context__.vals_i("overdisp")[(1 - 1)];
      current_statement__ = 105;
      context__.validate_dims("data initialization","postpred","int",
          context__.to_vec());
      postpred = std::numeric_limits<int>::min();
      
      current_statement__ = 105;
      postpred = context__.vals_i("postpred")[(1 - 1)];
      current_statement__ = 106;
      context__.validate_dims("data initialization","prior_sd","double",
          context__.to_vec());
      prior_sd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 106;
      prior_sd = context__.vals_r("prior_sd")[(1 - 1)];
      current_statement__ = 107;
      validate_non_negative_index("is_zero", "N_samples", N_samples);
      current_statement__ = 108;
      validate_non_negative_index("is_zero", "N_bins", N_bins);
      current_statement__ = 109;
      is_zero = std::vector<std::vector<int>>(N_samples, std::vector<int>(N_bins, std::numeric_limits<int>::min()));
      
      current_statement__ = 110;
      validate_non_negative_index("is_proportion", "N_samples", N_samples);
      current_statement__ = 111;
      validate_non_negative_index("is_proportion", "N_bins", N_bins);
      current_statement__ = 112;
      is_proportion = std::vector<std::vector<int>>(N_samples, std::vector<int>(N_bins, std::numeric_limits<int>::min()));
      
      current_statement__ = 113;
      validate_non_negative_index("logX", "N_samples", N_samples);
      current_statement__ = 114;
      validate_non_negative_index("logX", "N_bins", N_bins);
      current_statement__ = 115;
      logX = Eigen::Matrix<double, -1, -1>(N_samples, N_bins);
      stan::math::fill(logX, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 116;
      validate_non_negative_index("logNX", "N_samples", N_samples);
      current_statement__ = 117;
      validate_non_negative_index("logNX", "N_bins", N_bins);
      current_statement__ = 118;
      logNX = Eigen::Matrix<double, -1, -1>(N_samples, N_bins);
      stan::math::fill(logNX, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 119;
      validate_non_negative_index("ESS", "N_samples", N_samples);
      current_statement__ = 120;
      ESS = Eigen::Matrix<double, -1, 1>(N_samples);
      stan::math::fill(ESS, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 121;
      validate_non_negative_index("ones", "N_bins", N_bins);
      current_statement__ = 122;
      ones = Eigen::Matrix<double, -1, 1>(N_bins);
      stan::math::fill(ones, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 125;
      for (int i = 1; i <= N_bins; ++i) {
        current_statement__ = 123;
        assign(ones, cons_list(index_uni(i), nil_index_list()), 1,
          "assigning variable ones");}
      current_statement__ = 131;
      for (int i = 1; i <= N_samples; ++i) {
        current_statement__ = 126;
        assign(ESS, cons_list(index_uni(i), nil_index_list()), 0,
          "assigning variable ESS");
        current_statement__ = 129;
        for (int j = 1; j <= N_bins; ++j) {
          current_statement__ = 127;
          assign(ESS, cons_list(index_uni(i), nil_index_list()),
            (ESS[(i - 1)] +
              rvalue(X,
                cons_list(index_uni(i),
                  cons_list(index_uni(j), nil_index_list())), "X")),
            "assigning variable ESS");}}
      current_statement__ = 143;
      for (int i = 1; i <= N_samples; ++i) {
        current_statement__ = 141;
        for (int j = 1; j <= N_bins; ++j) {
          current_statement__ = 136;
          if (logical_eq(
                rvalue(X,
                  cons_list(index_uni(i),
                    cons_list(index_uni(j), nil_index_list())), "X"), 0)) {
            current_statement__ = 134;
            assign(is_zero,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())), 1,
              "assigning variable is_zero");
          } else {
            current_statement__ = 132;
            assign(is_zero,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())), 0,
              "assigning variable is_zero");
          }
          current_statement__ = 139;
          if ((primitive_value(
              logical_lt(
                rvalue(X,
                  cons_list(index_uni(i),
                    cons_list(index_uni(j), nil_index_list())), "X"),
                ESS[(i - 1)])) && primitive_value(
              logical_gt(
                rvalue(X,
                  cons_list(index_uni(i),
                    cons_list(index_uni(j), nil_index_list())), "X"), 0)))) {
            current_statement__ = 137;
            assign(is_proportion,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())), 1,
              "assigning variable is_proportion");
          } }}
      current_statement__ = 151;
      for (int i = 1; i <= N_samples; ++i) {
        current_statement__ = 149;
        for (int j = 1; j <= N_bins; ++j) {
          current_statement__ = 147;
          if (logical_eq(is_proportion[(i - 1)][(j - 1)], 1)) {
            current_statement__ = 144;
            assign(logX,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              stan::math::log(
                rvalue(X,
                  cons_list(index_uni(i),
                    cons_list(index_uni(j), nil_index_list())), "X")),
              "assigning variable logX");
            current_statement__ = 145;
            assign(logNX,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              stan::math::log(
                (ESS[(i - 1)] -
                  rvalue(X,
                    cons_list(index_uni(i),
                      cons_list(index_uni(j), nil_index_list())), "X"))),
              "assigning variable logNX");
          } }}
      current_statement__ = 152;
      validate_non_negative_index("phi_inv", "overdisp", overdisp);
      current_statement__ = 153;
      beta_raw_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 153;
      beta_raw_1dim__ = (N_bins - 1);
      current_statement__ = 153;
      validate_non_negative_index("beta_raw", "N_bins - 1", beta_raw_1dim__);
      current_statement__ = 154;
      validate_non_negative_index("beta_raw", "N_covar", N_covar);
      current_statement__ = 155;
      validate_non_negative_index("p_zero", "N_samples", N_samples);
      current_statement__ = 156;
      validate_non_negative_index("p_zero", "N_bins", N_bins);
      current_statement__ = 157;
      validate_non_negative_index("p_one", "N_samples", N_samples);
      current_statement__ = 158;
      validate_non_negative_index("p_one", "N_bins", N_bins);
      current_statement__ = 159;
      validate_non_negative_index("beta", "N_bins", N_bins);
      current_statement__ = 160;
      validate_non_negative_index("beta", "N_covar", N_covar);
      current_statement__ = 161;
      validate_non_negative_index("mu", "N_samples", N_samples);
      current_statement__ = 162;
      validate_non_negative_index("mu", "N_bins", N_bins);
      current_statement__ = 163;
      validate_non_negative_index("log_lik", "N_samples", N_samples);
      current_statement__ = 164;
      validate_non_negative_index("log_lik", "N_bins", N_bins);
      current_statement__ = 165;
      ynew_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 165;
      ynew_1dim__ = (N_samples * postpred);
      current_statement__ = 165;
      validate_non_negative_index("ynew", "N_samples * postpred", ynew_1dim__);
      current_statement__ = 166;
      ynew_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 166;
      ynew_2dim__ = (N_bins * postpred);
      current_statement__ = 166;
      validate_non_negative_index("ynew", "N_bins * postpred", ynew_2dim__);
      current_statement__ = 167;
      newy_is_zero_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 167;
      newy_is_zero_1dim__ = (N_samples * postpred);
      current_statement__ = 167;
      validate_non_negative_index("newy_is_zero", "N_samples * postpred",
                                  newy_is_zero_1dim__);
      current_statement__ = 168;
      newy_is_zero_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 168;
      newy_is_zero_2dim__ = (N_bins * postpred);
      current_statement__ = 168;
      validate_non_negative_index("newy_is_zero", "N_bins * postpred",
                                  newy_is_zero_2dim__);
      current_statement__ = 169;
      newy_is_one_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 169;
      newy_is_one_1dim__ = (N_samples * postpred);
      current_statement__ = 169;
      validate_non_negative_index("newy_is_one", "N_samples * postpred",
                                  newy_is_one_1dim__);
      current_statement__ = 170;
      newy_is_one_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 170;
      newy_is_one_2dim__ = (N_bins * postpred);
      current_statement__ = 170;
      validate_non_negative_index("newy_is_one", "N_bins * postpred",
                                  newy_is_one_2dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += overdisp;
      num_params_r__ += beta_raw_1dim__ * N_covar;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_dirichregmod_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> phi_inv;
      phi_inv = Eigen::Matrix<local_scalar_t__, -1, 1>(overdisp);
      stan::math::fill(phi_inv, DUMMY_VAR__);
      
      current_statement__ = 1;
      phi_inv = in__.vector(overdisp);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= overdisp; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(phi_inv, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(phi_inv[(sym1__ - 1)], 0, lp__),
            "assigning variable phi_inv");
        } else {
          current_statement__ = 1;
          assign(phi_inv, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(phi_inv[(sym1__ - 1)], 0),
            "assigning variable phi_inv");
        }}
      Eigen::Matrix<local_scalar_t__, -1, -1> beta_raw;
      beta_raw = Eigen::Matrix<local_scalar_t__, -1, -1>(beta_raw_1dim__, N_covar);
      stan::math::fill(beta_raw, DUMMY_VAR__);
      
      current_statement__ = 2;
      beta_raw = in__.matrix(beta_raw_1dim__, N_covar);
      local_scalar_t__ phi;
      phi = DUMMY_VAR__;
      
      Eigen::Matrix<local_scalar_t__, -1, -1> p_zero;
      p_zero = Eigen::Matrix<local_scalar_t__, -1, -1>(N_samples, N_bins);
      stan::math::fill(p_zero, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> p_one;
      p_one = Eigen::Matrix<local_scalar_t__, -1, -1>(N_samples, N_bins);
      stan::math::fill(p_one, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, -1>(N_bins, N_covar);
      stan::math::fill(beta, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> mu;
      mu = Eigen::Matrix<local_scalar_t__, -1, -1>(N_samples, N_bins);
      stan::math::fill(mu, DUMMY_VAR__);
      
      current_statement__ = 8;
      phi = 1;
      current_statement__ = 11;
      if (logical_eq(overdisp, 1)) {
        current_statement__ = 9;
        phi = (1 / phi_inv[(1 - 1)]);
      } 
      current_statement__ = 14;
      for (int l = 1; l <= N_covar; ++l) {
        current_statement__ = 12;
        assign(beta,
          cons_list(index_uni(N_bins),
            cons_list(index_uni(l), nil_index_list())), 0.0,
          "assigning variable beta");}
      current_statement__ = 19;
      for (int k = 1; k <= (N_bins - 1); ++k) {
        current_statement__ = 17;
        for (int l = 1; l <= N_covar; ++l) {
          current_statement__ = 15;
          assign(beta,
            cons_list(index_uni(k),
              cons_list(index_uni(l), nil_index_list())),
            rvalue(beta_raw,
              cons_list(index_uni(k),
                cons_list(index_uni(l), nil_index_list())), "beta_raw"),
            "assigning variable beta");}}
      current_statement__ = 30;
      for (int n = 1; n <= N_samples; ++n) {
        current_statement__ = 20;
        validate_non_negative_index("logits", "N_bins", N_bins);
        Eigen::Matrix<local_scalar_t__, -1, 1> logits;
        logits = Eigen::Matrix<local_scalar_t__, -1, 1>(N_bins);
        stan::math::fill(logits, DUMMY_VAR__);
        
        current_statement__ = 24;
        for (int m = 1; m <= N_bins; ++m) {
          current_statement__ = 22;
          assign(logits, cons_list(index_uni(m), nil_index_list()),
            multiply(
              rvalue(design_X,
                cons_list(index_uni(n),
                  cons_list(index_omni(), nil_index_list())), "design_X"),
              transpose(
                rvalue(beta,
                  cons_list(index_uni(m),
                    cons_list(index_omni(), nil_index_list())), "beta"))),
            "assigning variable logits");}
        current_statement__ = 25;
        assign(logits, nil_index_list(),
          softmax(stan::model::deep_copy(logits)),
          "assigning variable logits");
        current_statement__ = 28;
        for (int m = 1; m <= N_bins; ++m) {
          current_statement__ = 26;
          assign(mu,
            cons_list(index_uni(n),
              cons_list(index_uni(m), nil_index_list())), logits[(m - 1)],
            "assigning variable mu");}}
      current_statement__ = 38;
      for (int i = 1; i <= N_samples; ++i) {
        current_statement__ = 33;
        for (int j = 1; j <= N_bins; ++j) {
          current_statement__ = 31;
          assign(p_zero,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            pow(
              (1 -
                rvalue(mu,
                  cons_list(index_uni(i),
                    cons_list(index_uni(j), nil_index_list())), "mu")),
              (ESS[(i - 1)] * phi)), "assigning variable p_zero");}
        current_statement__ = 36;
        for (int j = 1; j <= N_bins; ++j) {
          current_statement__ = 34;
          assign(p_one,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            ((1 -
               rvalue(p_zero,
                 cons_list(index_uni(i),
                   cons_list(index_uni(j), nil_index_list())), "p_zero")) *
              prod(
                rvalue(p_zero,
                  cons_list(index_uni(i),
                    cons_list(
                      index_multi(rvalue(prod_idx,
                                    cons_list(index_uni(j),
                                      cons_list(index_omni(),
                                        nil_index_list())), "prod_idx")),
                      nil_index_list())), "p_zero"))),
            "assigning variable p_one");}}
      current_statement__ = 3;
      current_statement__ = 3;
      check_greater_or_equal(function__, "phi", phi, 0);
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 4;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 4;
          current_statement__ = 4;
          check_greater_or_equal(function__, "p_zero[sym1__, sym2__]",
                                 rvalue(p_zero,
                                   cons_list(index_uni(sym1__),
                                     cons_list(index_uni(sym2__),
                                       nil_index_list())), "p_zero"), 0);}}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 4;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 4;
          current_statement__ = 4;
          check_less_or_equal(function__, "p_zero[sym1__, sym2__]",
                              rvalue(p_zero,
                                cons_list(index_uni(sym1__),
                                  cons_list(index_uni(sym2__),
                                    nil_index_list())), "p_zero"), 1);}}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 5;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 5;
          current_statement__ = 5;
          check_greater_or_equal(function__, "p_one[sym1__, sym2__]",
                                 rvalue(p_one,
                                   cons_list(index_uni(sym1__),
                                     cons_list(index_uni(sym2__),
                                       nil_index_list())), "p_one"), 0);}}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 5;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 5;
          current_statement__ = 5;
          check_less_or_equal(function__, "p_one[sym1__, sym2__]",
                              rvalue(p_one,
                                cons_list(index_uni(sym1__),
                                  cons_list(index_uni(sym2__),
                                    nil_index_list())), "p_one"), 1);}}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 7;
          current_statement__ = 7;
          check_greater_or_equal(function__, "mu[sym1__, sym2__]",
                                 rvalue(mu,
                                   cons_list(index_uni(sym1__),
                                     cons_list(index_uni(sym2__),
                                       nil_index_list())), "mu"), 0);}}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 7;
          current_statement__ = 7;
          check_less_or_equal(function__, "mu[sym1__, sym2__]",
                              rvalue(mu,
                                cons_list(index_uni(sym1__),
                                  cons_list(index_uni(sym2__),
                                    nil_index_list())), "mu"), 1);}}
      {
        local_scalar_t__ alpha_temp;
        alpha_temp = DUMMY_VAR__;
        
        local_scalar_t__ beta_temp;
        beta_temp = DUMMY_VAR__;
        
        current_statement__ = 76;
        if (logical_eq(overdisp, 1)) {
          current_statement__ = 74;
          lp_accum__.add(cauchy_lpdf<propto__>(phi_inv, 0, 5));
        } 
        current_statement__ = 81;
        for (int i = 1; i <= N_covar; ++i) {
          current_statement__ = 79;
          for (int j = 1; j <= (N_bins - 1); ++j) {
            current_statement__ = 77;
            lp_accum__.add(
              normal_lpdf<propto__>(
                rvalue(beta_raw,
                  cons_list(index_uni(j),
                    cons_list(index_uni(i), nil_index_list())), "beta_raw"),
                0, prior_sd));}}
        current_statement__ = 91;
        for (int i = 1; i <= N_samples; ++i) {
          current_statement__ = 89;
          for (int j = 1; j <= N_bins; ++j) {
            current_statement__ = 82;
            lp_accum__.add(
              bernoulli_lpmf<false>(is_zero[(i - 1)][(j - 1)],
                rvalue(p_zero,
                  cons_list(index_uni(i),
                    cons_list(index_uni(j), nil_index_list())), "p_zero")));
            current_statement__ = 87;
            if (logical_eq(is_proportion[(i - 1)][(j - 1)], 1)) {
              current_statement__ = 83;
              alpha_temp = ((rvalue(mu,
                               cons_list(index_uni(i),
                                 cons_list(index_uni(j), nil_index_list())),
                               "mu") * ESS[(i - 1)]) * phi);
              current_statement__ = 84;
              beta_temp = (((1 -
                              rvalue(mu,
                                cons_list(index_uni(i),
                                  cons_list(index_uni(j), nil_index_list())),
                                "mu")) * ESS[(i - 1)]) * phi);
              current_statement__ = 85;
              lp_accum__.add(
                ((((stan::math::log(
                      ((1 -
                         rvalue(p_zero,
                           cons_list(index_uni(i),
                             cons_list(index_uni(j), nil_index_list())),
                           "p_zero")) -
                        rvalue(p_one,
                          cons_list(index_uni(i),
                            cons_list(index_uni(j), nil_index_list())),
                          "p_one"))) +
                     ((alpha_temp - 1) *
                       rvalue(logX,
                         cons_list(index_uni(i),
                           cons_list(index_uni(j), nil_index_list())),
                         "logX"))) +
                    ((beta_temp - 1) *
                      rvalue(logNX,
                        cons_list(index_uni(i),
                          cons_list(index_uni(j), nil_index_list())),
                        "logNX"))) -
                   (((alpha_temp + beta_temp) - 1) *
                     stan::math::log(ESS[(i - 1)]))) -
                  lbeta(alpha_temp, beta_temp)));
            } }}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_dirichregmod_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> phi_inv;
      phi_inv = Eigen::Matrix<double, -1, 1>(overdisp);
      stan::math::fill(phi_inv, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      phi_inv = in__.vector(overdisp);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= overdisp; ++sym1__) {
        current_statement__ = 1;
        assign(phi_inv, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(phi_inv[(sym1__ - 1)], 0),
          "assigning variable phi_inv");}
      Eigen::Matrix<double, -1, -1> beta_raw;
      beta_raw = Eigen::Matrix<double, -1, -1>(beta_raw_1dim__, N_covar);
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      beta_raw = in__.matrix(beta_raw_1dim__, N_covar);
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, -1> p_zero;
      p_zero = Eigen::Matrix<double, -1, -1>(N_samples, N_bins);
      stan::math::fill(p_zero, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> p_one;
      p_one = Eigen::Matrix<double, -1, -1>(N_samples, N_bins);
      stan::math::fill(p_one, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> beta;
      beta = Eigen::Matrix<double, -1, -1>(N_bins, N_covar);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> mu;
      mu = Eigen::Matrix<double, -1, -1>(N_samples, N_bins);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= overdisp; ++sym1__) {
        vars__.emplace_back(phi_inv[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_covar; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= beta_raw_1dim__; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta_raw"));
        }}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 8;
      phi = 1;
      current_statement__ = 11;
      if (logical_eq(overdisp, 1)) {
        current_statement__ = 9;
        phi = (1 / phi_inv[(1 - 1)]);
      } 
      current_statement__ = 14;
      for (int l = 1; l <= N_covar; ++l) {
        current_statement__ = 12;
        assign(beta,
          cons_list(index_uni(N_bins),
            cons_list(index_uni(l), nil_index_list())), 0.0,
          "assigning variable beta");}
      current_statement__ = 19;
      for (int k = 1; k <= (N_bins - 1); ++k) {
        current_statement__ = 17;
        for (int l = 1; l <= N_covar; ++l) {
          current_statement__ = 15;
          assign(beta,
            cons_list(index_uni(k),
              cons_list(index_uni(l), nil_index_list())),
            rvalue(beta_raw,
              cons_list(index_uni(k),
                cons_list(index_uni(l), nil_index_list())), "beta_raw"),
            "assigning variable beta");}}
      current_statement__ = 30;
      for (int n = 1; n <= N_samples; ++n) {
        current_statement__ = 20;
        validate_non_negative_index("logits", "N_bins", N_bins);
        Eigen::Matrix<double, -1, 1> logits;
        logits = Eigen::Matrix<double, -1, 1>(N_bins);
        stan::math::fill(logits, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 24;
        for (int m = 1; m <= N_bins; ++m) {
          current_statement__ = 22;
          assign(logits, cons_list(index_uni(m), nil_index_list()),
            multiply(
              rvalue(design_X,
                cons_list(index_uni(n),
                  cons_list(index_omni(), nil_index_list())), "design_X"),
              transpose(
                rvalue(beta,
                  cons_list(index_uni(m),
                    cons_list(index_omni(), nil_index_list())), "beta"))),
            "assigning variable logits");}
        current_statement__ = 25;
        assign(logits, nil_index_list(),
          softmax(stan::model::deep_copy(logits)),
          "assigning variable logits");
        current_statement__ = 28;
        for (int m = 1; m <= N_bins; ++m) {
          current_statement__ = 26;
          assign(mu,
            cons_list(index_uni(n),
              cons_list(index_uni(m), nil_index_list())), logits[(m - 1)],
            "assigning variable mu");}}
      current_statement__ = 38;
      for (int i = 1; i <= N_samples; ++i) {
        current_statement__ = 33;
        for (int j = 1; j <= N_bins; ++j) {
          current_statement__ = 31;
          assign(p_zero,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            pow(
              (1 -
                rvalue(mu,
                  cons_list(index_uni(i),
                    cons_list(index_uni(j), nil_index_list())), "mu")),
              (ESS[(i - 1)] * phi)), "assigning variable p_zero");}
        current_statement__ = 36;
        for (int j = 1; j <= N_bins; ++j) {
          current_statement__ = 34;
          assign(p_one,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            ((1 -
               rvalue(p_zero,
                 cons_list(index_uni(i),
                   cons_list(index_uni(j), nil_index_list())), "p_zero")) *
              prod(
                rvalue(p_zero,
                  cons_list(index_uni(i),
                    cons_list(
                      index_multi(rvalue(prod_idx,
                                    cons_list(index_uni(j),
                                      cons_list(index_omni(),
                                        nil_index_list())), "prod_idx")),
                      nil_index_list())), "p_zero"))),
            "assigning variable p_one");}}
      current_statement__ = 3;
      current_statement__ = 3;
      check_greater_or_equal(function__, "phi", phi, 0);
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 4;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 4;
          current_statement__ = 4;
          check_greater_or_equal(function__, "p_zero[sym1__, sym2__]",
                                 rvalue(p_zero,
                                   cons_list(index_uni(sym1__),
                                     cons_list(index_uni(sym2__),
                                       nil_index_list())), "p_zero"), 0);}}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 4;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 4;
          current_statement__ = 4;
          check_less_or_equal(function__, "p_zero[sym1__, sym2__]",
                              rvalue(p_zero,
                                cons_list(index_uni(sym1__),
                                  cons_list(index_uni(sym2__),
                                    nil_index_list())), "p_zero"), 1);}}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 5;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 5;
          current_statement__ = 5;
          check_greater_or_equal(function__, "p_one[sym1__, sym2__]",
                                 rvalue(p_one,
                                   cons_list(index_uni(sym1__),
                                     cons_list(index_uni(sym2__),
                                       nil_index_list())), "p_one"), 0);}}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 5;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 5;
          current_statement__ = 5;
          check_less_or_equal(function__, "p_one[sym1__, sym2__]",
                              rvalue(p_one,
                                cons_list(index_uni(sym1__),
                                  cons_list(index_uni(sym2__),
                                    nil_index_list())), "p_one"), 1);}}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 7;
          current_statement__ = 7;
          check_greater_or_equal(function__, "mu[sym1__, sym2__]",
                                 rvalue(mu,
                                   cons_list(index_uni(sym1__),
                                     cons_list(index_uni(sym2__),
                                       nil_index_list())), "mu"), 0);}}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N_samples; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
          current_statement__ = 7;
          current_statement__ = 7;
          check_less_or_equal(function__, "mu[sym1__, sym2__]",
                              rvalue(mu,
                                cons_list(index_uni(sym1__),
                                  cons_list(index_uni(sym2__),
                                    nil_index_list())), "mu"), 1);}}
      if (emit_transformed_parameters__) {
        vars__.emplace_back(phi);
        for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            vars__.emplace_back(
              rvalue(p_zero,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "p_zero"));
          }}
        for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            vars__.emplace_back(
              rvalue(p_one,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "p_one"));
          }}
        for (int sym1__ = 1; sym1__ <= N_covar; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
            vars__.emplace_back(
              rvalue(beta,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "beta"));}
        }
        for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            vars__.emplace_back(
              rvalue(mu,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "mu"));}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      double alpha_temp;
      alpha_temp = std::numeric_limits<double>::quiet_NaN();
      
      double beta_temp;
      beta_temp = std::numeric_limits<double>::quiet_NaN();
      
      std::vector<Eigen::Matrix<double, -1, 1>> log_lik;
      log_lik = std::vector<Eigen::Matrix<double, -1, 1>>(N_samples, Eigen::Matrix<double, -1, 1>(N_bins));
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> ynew;
      ynew = std::vector<Eigen::Matrix<double, -1, 1>>(ynew_1dim__, Eigen::Matrix<double, -1, 1>(ynew_2dim__));
      stan::math::fill(ynew, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<std::vector<int>> newy_is_zero;
      newy_is_zero = std::vector<std::vector<int>>(newy_is_zero_1dim__, std::vector<int>(newy_is_zero_2dim__, std::numeric_limits<int>::min()));
      
      std::vector<std::vector<int>> newy_is_one;
      newy_is_one = std::vector<std::vector<int>>(newy_is_one_1dim__, std::vector<int>(newy_is_one_2dim__, std::numeric_limits<int>::min()));
      
      int newy_is_proportion;
      newy_is_proportion = std::numeric_limits<int>::min();
      
      current_statement__ = 71;
      for (int i = 1; i <= N_samples; ++i) {
        current_statement__ = 69;
        for (int j = 1; j <= N_bins; ++j) {
          current_statement__ = 46;
          assign(log_lik,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())), 0,
            "assigning variable log_lik");
          current_statement__ = 47;
          assign(log_lik,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            (log_lik[(i - 1)][(j - 1)] +
              bernoulli_lpmf<false>(is_zero[(i - 1)][(j - 1)],
                rvalue(p_zero,
                  cons_list(index_uni(i),
                    cons_list(index_uni(j), nil_index_list())), "p_zero"))),
            "assigning variable log_lik");
          current_statement__ = 52;
          if (logical_eq(is_proportion[(i - 1)][(j - 1)], 1)) {
            current_statement__ = 48;
            alpha_temp = ((rvalue(mu,
                             cons_list(index_uni(i),
                               cons_list(index_uni(j), nil_index_list())),
                             "mu") * ESS[(i - 1)]) * phi);
            current_statement__ = 49;
            beta_temp = (((1 -
                            rvalue(mu,
                              cons_list(index_uni(i),
                                cons_list(index_uni(j), nil_index_list())),
                              "mu")) * ESS[(i - 1)]) * phi);
            current_statement__ = 50;
            assign(log_lik,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              (log_lik[(i - 1)][(j - 1)] +
                ((((stan::math::log(
                      ((1 -
                         rvalue(p_zero,
                           cons_list(index_uni(i),
                             cons_list(index_uni(j), nil_index_list())),
                           "p_zero")) -
                        rvalue(p_one,
                          cons_list(index_uni(i),
                            cons_list(index_uni(j), nil_index_list())),
                          "p_one"))) +
                     ((alpha_temp - 1) *
                       rvalue(logX,
                         cons_list(index_uni(i),
                           cons_list(index_uni(j), nil_index_list())),
                         "logX"))) +
                    ((beta_temp - 1) *
                      rvalue(logNX,
                        cons_list(index_uni(i),
                          cons_list(index_uni(j), nil_index_list())),
                        "logNX"))) -
                   (((alpha_temp + beta_temp) - 1) *
                     stan::math::log(ESS[(i - 1)]))) -
                  lbeta(alpha_temp, beta_temp))),
              "assigning variable log_lik");
          } 
          current_statement__ = 67;
          if (logical_eq(postpred, 1)) {
            current_statement__ = 53;
            assign(newy_is_zero,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              bernoulli_rng(
                rvalue(p_zero,
                  cons_list(index_uni(i),
                    cons_list(index_uni(j), nil_index_list())), "p_zero"),
                base_rng__), "assigning variable newy_is_zero");
            current_statement__ = 55;
            if (logical_eq(newy_is_zero[(i - 1)][(j - 1)], 1)) {
              current_statement__ = 54;
              assign(ynew,
                cons_list(index_uni(i),
                  cons_list(index_uni(j), nil_index_list())), 0.0,
                "assigning variable ynew");
            } 
            current_statement__ = 56;
            assign(newy_is_one,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              bernoulli_rng(
                rvalue(p_one,
                  cons_list(index_uni(i),
                    cons_list(index_uni(j), nil_index_list())), "p_one"),
                base_rng__), "assigning variable newy_is_one");
            current_statement__ = 58;
            if (logical_eq(newy_is_one[(i - 1)][(j - 1)], 1)) {
              current_statement__ = 57;
              assign(ynew,
                cons_list(index_uni(i),
                  cons_list(index_uni(j), nil_index_list())), 1.0,
                "assigning variable ynew");
            } 
            current_statement__ = 59;
            newy_is_proportion = (newy_is_zero[(i - 1)][(j - 1)] +
                                   newy_is_one[(i - 1)][(j - 1)]);
            current_statement__ = 65;
            if (logical_eq(newy_is_proportion, 0)) {
              current_statement__ = 60;
              alpha_temp = (rvalue(mu,
                              cons_list(index_uni(i),
                                cons_list(index_uni(j), nil_index_list())),
                              "mu") * ESS[(i - 1)]);
              current_statement__ = 61;
              beta_temp = ((1 -
                             rvalue(mu,
                               cons_list(index_uni(i),
                                 cons_list(index_uni(j), nil_index_list())),
                               "mu")) * ESS[(i - 1)]);
              current_statement__ = 62;
              assign(ynew,
                cons_list(index_uni(i),
                  cons_list(index_uni(j), nil_index_list())),
                beta_rng(alpha_temp, beta_temp, base_rng__),
                "assigning variable ynew");
              current_statement__ = 63;
              assign(ynew,
                cons_list(index_uni(i),
                  cons_list(index_uni(j), nil_index_list())),
                (ynew[(i - 1)][(j - 1)] * ESS[(i - 1)]),
                "assigning variable ynew");
            } 
          } }}
      vars__.emplace_back(alpha_temp);
      vars__.emplace_back(beta_temp);
      for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
          vars__.emplace_back(log_lik[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= ynew_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ynew_1dim__; ++sym2__) {
          vars__.emplace_back(ynew[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= newy_is_zero_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= newy_is_zero_1dim__; ++sym2__) {
          vars__.emplace_back(newy_is_zero[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= newy_is_one_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= newy_is_one_1dim__; ++sym2__) {
          vars__.emplace_back(newy_is_one[(sym2__ - 1)][(sym1__ - 1)]);}}
      vars__.emplace_back(newy_is_proportion);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> phi_inv;
      phi_inv = Eigen::Matrix<double, -1, 1>(overdisp);
      stan::math::fill(phi_inv, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi_inv_flat__;
        current_statement__ = 1;
        assign(phi_inv_flat__, nil_index_list(), context__.vals_r("phi_inv"),
          "assigning variable phi_inv_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= overdisp; ++sym1__) {
          current_statement__ = 1;
          assign(phi_inv, cons_list(index_uni(sym1__), nil_index_list()),
            phi_inv_flat__[(pos__ - 1)], "assigning variable phi_inv");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> phi_inv_free__;
      phi_inv_free__ = Eigen::Matrix<double, -1, 1>(overdisp);
      stan::math::fill(phi_inv_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= overdisp; ++sym1__) {
        current_statement__ = 1;
        assign(phi_inv_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(phi_inv[(sym1__ - 1)], 0),
          "assigning variable phi_inv_free__");}
      Eigen::Matrix<double, -1, -1> beta_raw;
      beta_raw = Eigen::Matrix<double, -1, -1>(beta_raw_1dim__, N_covar);
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_raw_flat__;
        current_statement__ = 2;
        assign(beta_raw_flat__, nil_index_list(),
          context__.vals_r("beta_raw"), "assigning variable beta_raw_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= N_covar; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= beta_raw_1dim__; ++sym2__) {
            current_statement__ = 2;
            assign(beta_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              beta_raw_flat__[(pos__ - 1)], "assigning variable beta_raw");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      for (int sym1__ = 1; sym1__ <= overdisp; ++sym1__) {
        vars__.emplace_back(phi_inv_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_covar; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= beta_raw_1dim__; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta_raw"));
        }}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("phi_inv");
    names__.emplace_back("beta_raw");
    names__.emplace_back("phi");
    names__.emplace_back("p_zero");
    names__.emplace_back("p_one");
    names__.emplace_back("beta");
    names__.emplace_back("mu");
    names__.emplace_back("alpha_temp");
    names__.emplace_back("beta_temp");
    names__.emplace_back("log_lik");
    names__.emplace_back("ynew");
    names__.emplace_back("newy_is_zero");
    names__.emplace_back("newy_is_one");
    names__.emplace_back("newy_is_proportion");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(overdisp)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(beta_raw_1dim__)
                                             , static_cast<size_t>(N_covar)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_samples),
                                             static_cast<size_t>(N_bins)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_samples),
                                             static_cast<size_t>(N_bins)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_bins),
                                             static_cast<size_t>(N_covar)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_samples),
                                             static_cast<size_t>(N_bins)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_samples),
                                             static_cast<size_t>(N_bins)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ynew_1dim__)
                                             ,
                                             static_cast<size_t>(ynew_2dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(newy_is_zero_1dim__)
                                             ,
                                             static_cast<size_t>(newy_is_zero_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(newy_is_one_1dim__)
                                             ,
                                             static_cast<size_t>(newy_is_one_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= overdisp; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi_inv" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_covar; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= beta_raw_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "phi");
      for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "p_zero" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "p_one" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_covar; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "alpha_temp");
      param_names__.emplace_back(std::string() + "beta_temp");
      for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= ynew_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ynew_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "ynew" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= newy_is_zero_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= newy_is_zero_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "newy_is_zero" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= newy_is_one_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= newy_is_one_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "newy_is_one" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      param_names__.emplace_back(std::string() + "newy_is_proportion");
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= overdisp; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi_inv" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_covar; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= beta_raw_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "phi");
      for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "p_zero" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "p_one" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_covar; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_bins; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "alpha_temp");
      param_names__.emplace_back(std::string() + "beta_temp");
      for (int sym1__ = 1; sym1__ <= N_bins; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_samples; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= ynew_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ynew_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "ynew" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= newy_is_zero_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= newy_is_zero_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "newy_is_zero" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= newy_is_one_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= newy_is_one_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "newy_is_one" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      param_names__.emplace_back(std::string() + "newy_is_proportion");
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi_inv\",\"type\":{\"name\":\"vector\",\"length\":" << overdisp << "},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" << beta_raw_1dim__ << ",\"cols\":" << N_covar << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"p_zero\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_samples << ",\"cols\":" << N_bins << "},\"block\":\"transformed_parameters\"},{\"name\":\"p_one\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_samples << ",\"cols\":" << N_bins << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_bins << ",\"cols\":" << N_covar << "},\"block\":\"transformed_parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_samples << ",\"cols\":" << N_bins << "},\"block\":\"transformed_parameters\"},{\"name\":\"alpha_temp\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"beta_temp\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << N_samples << ",\"element_type\":{\"name\":\"vector\",\"length\":" << N_bins << "}},\"block\":\"generated_quantities\"},{\"name\":\"ynew\",\"type\":{\"name\":\"array\",\"length\":" << ynew_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ynew_2dim__ << "}},\"block\":\"generated_quantities\"},{\"name\":\"newy_is_zero\",\"type\":{\"name\":\"array\",\"length\":" << newy_is_zero_1dim__ << ",\"element_type\":{\"name\":\"array\",\"length\":" << newy_is_zero_2dim__ << ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"},{\"name\":\"newy_is_one\",\"type\":{\"name\":\"array\",\"length\":" << newy_is_one_1dim__ << ",\"element_type\":{\"name\":\"array\",\"length\":" << newy_is_one_2dim__ << ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"},{\"name\":\"newy_is_proportion\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi_inv\",\"type\":{\"name\":\"vector\",\"length\":" << overdisp << "},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" << beta_raw_1dim__ << ",\"cols\":" << N_covar << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"p_zero\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_samples << ",\"cols\":" << N_bins << "},\"block\":\"transformed_parameters\"},{\"name\":\"p_one\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_samples << ",\"cols\":" << N_bins << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_bins << ",\"cols\":" << N_covar << "},\"block\":\"transformed_parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"matrix\",\"rows\":" << N_samples << ",\"cols\":" << N_bins << "},\"block\":\"transformed_parameters\"},{\"name\":\"alpha_temp\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"beta_temp\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << N_samples << ",\"element_type\":{\"name\":\"vector\",\"length\":" << N_bins << "}},\"block\":\"generated_quantities\"},{\"name\":\"ynew\",\"type\":{\"name\":\"array\",\"length\":" << ynew_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ynew_2dim__ << "}},\"block\":\"generated_quantities\"},{\"name\":\"newy_is_zero\",\"type\":{\"name\":\"array\",\"length\":" << newy_is_zero_1dim__ << ",\"element_type\":{\"name\":\"array\",\"length\":" << newy_is_zero_2dim__ << ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"},{\"name\":\"newy_is_one\",\"type\":{\"name\":\"array\",\"length\":" << newy_is_one_1dim__ << ",\"element_type\":{\"name\":\"array\",\"length\":" << newy_is_one_2dim__ << ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"},{\"name\":\"newy_is_proportion\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_dirichregmod_namespace::model_dirichregmod;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_dirichregmod_namespace::profiles__;
}
#endif
#endif
