% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pars.R
\name{get_pars}
\alias{get_pars}
\title{Extract parameters from fitted model.}
\usage{
get_pars(fitted_model, conf_int = 0.05)
}
\arguments{
\item{fitted_model}{The fitted model returned as an rstan object from the call to zoid}

\item{conf_int}{Parameter controlling confidence intervals calculated, defaults to 0.05
for 95\% intervals}
}
\value{
A list containing the posterior summaries of estimated parameters. At minimum,
this will include \code{p} (the estimated proportions) and \code{betas} (the predicted values in
transformed space). For models with overdispersion, an extra
element \code{phi} will also be returned, summarizing overdispersion. For predictions
in normal space, see \code{\link[=get_fitted]{get_fitted()}}
}
\description{
Extract estimated parameters from fitted model.
}
\examples{
\donttest{
y <- matrix(c(3.77, 6.63, 2.60, 0.9, 1.44, 0.66, 2.10, 3.57, 1.33),
  nrow = 3, byrow = TRUE
)
# fit a model with no covariates
fit <- fit_zoid(data_matrix = y)
p_hat <- get_pars(fit)
}

}
