% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmfit.R
\name{hmmfit}
\alias{hmmfit}
\title{Estimate the parameters of a homogeneous hidden Markov model 
by directly minimizing of the negative log-likelihood function}
\usage{
hmmfit(y, ntimes = NULL, M, prior_init, tpm_init, emit_init, zero_init,
  prior_x = NULL, tpm_x = NULL, emit_x = NULL, zeroinfl_x = NULL,
  method = "Nelder-Mead", hessian = FALSE, ...)
}
\arguments{
\item{y}{observed time series values}

\item{ntimes}{a vector specifying the lengths of individual, 
i.e. independent, time series. If not specified, the responses are assumed to 
form a single time series, i.e. ntimes=length(y)}

\item{M}{number of latent states}

\item{prior_init}{a vector of initial values for prior probability for each state}

\item{tpm_init}{a matrix of initial values for transition probability matrix}

\item{emit_init}{a vector of initial values for the means for each poisson distribution}

\item{zero_init}{a vector of initial values for the structural zero proportions in each state}

\item{prior_x}{matrix of covariates for generalized logit of prior probabilites (excluding the 
1st probability). Default to NULL.}

\item{tpm_x}{matrix of covariates for transition probability matrix (excluding the 1st column).
Default to NULL.}

\item{emit_x}{matrix of covariates for the log poisson means. Default to NULL.}

\item{zeroinfl_x}{matrix of covariates for the nonzero structural zero proportions. Default to NULL.}

\item{method}{method to be used for direct numeric optimization. See details in
the help page for optim() function. Default to Nelder-Mead.}

\item{hessian}{Logical. Should a numerically differentiated Hessian matrix be returned?
Note that the hessian is for the working parameters, which are the generalized logit of prior 
probabilities (except for state 1), the generalized logit of the transition probability 
matrix(except 1st column), the logit of non-zero zero proportions, and the log of 
each state-dependent poisson means}

\item{...}{Further arguments passed on to the optimization methods}
}
\value{
the maximum likelihood estimates of the zero-inflated hidden Markov model
}
\description{
Estimate the parameters of a homogeneous hidden Markov model 
by directly minimizing of the negative log-likelihood function
}
\examples{
prior_init <- c(0.5,0.2,0.3)
emit_init <- c(10,40,70)
zero_init <- c(0.5,0,0)
omega <- matrix(c(0.5,0.3,0.2,0.4,0.3,0.3,0.2,0.4,0.4),3,3,byrow=TRUE)
result <- hmmsim(n=1000,M=3,prior=prior_init, tpm_parm=omega,
         emit_parm=emit_init,zeroprop=zero_init)
y <- result$series
fit <- hmmfit(y=y,M=3,prior_init=prior_init,tpm_init=omega,
     emit_init=emit_init,zero_init=zero_init,
     method="Nelder-Mead",hessian=TRUE,control=list(maxit=500,trace=1))
str(fit)

#variances for the 12 working parameters, which are the logit of prior probabilities
#for state 2 and state 3, the generalized logit of the transition probability matrix
#(tpm[1,2],tpm[1,3],tpm[2,2],tpm[2,3],tpm[3,2],tpm[3,3]), the logit of structural zero
#proportions for state 1, and log of poisson means for state 1, 2, and 3
#logit of non-zero zero proportions, and the log of poisson means
variance <- diag(solve(fit$obsinfo))

#with covariates
data(CAT)
y <- CAT$activity
x <- data.matrix(CAT$night)
prior_init <- c(0.5,0.2,0.3)
emit_init <- c(10,50,100)
zero_init <- c(0.5,0,0)
omega <- matrix(c(0.5,0.3,0.2,0.4,0.3,0.3,0.2,0.4,0.4),3,3,byrow=TRUE)
fit2 <-  hmmfit(y,rep(1440,3),3,prior_init,omega,
     emit_init,zero_init, emit_x=x,zeroinfl_x=x,hessian=FALSE,
     method="Nelder-Mead", control=list(maxit=500,trace=1))
fit2
     
\dontrun{
#two zero-inflated poissons
prior_init <- c(0.5,0.5)
emit_init <- c(10,50)
zero_init <- c(0.6,0.3)
omega <- matrix(c(0.9,0.1,0.2,0.8),2,2,byrow=TRUE)
result <- hmmsim(n=1000,M=2,prior=prior_init, tpm_parm=omega,
         emit_parm=emit_init,zeroprop=zero_init)
y <- result$series
fit <- hmmfit(y=y,M=2,prior_init=prior_init,tpm_init=omega,
     emit_init=emit_init,zero_init=zero_init,
     method="Nelder-Mead",hessian=FALSE,control=list(maxit=500,trace=1))
str(fit)

#four regular poissons
prior_init <- c(0.4,0.2,0.2,0.2)
emit_init <- c(10,40,70,100)
zero_init <- c(0,0,0,0)
omega <- matrix(c(0.3,0.3,0.2,0.2,0.4,0.2,0.3,0.1,
                  0.2,0.2,0.3,0.3,0.1,0.2,0.3,0.4),4,4,byrow=TRUE)
result <- hmmsim(n=1000,M=4,prior=prior_init, tpm_parm=omega,
         emit_parm=emit_init,zeroprop=zero_init)
y <- result$series
fit <- hmmfit(y=y,M=4,prior_init=prior_init,tpm_init=omega,
     emit_init=emit_init,zero_init=zero_init,
     method="Nelder-Mead",hessian=FALSE,control=list(maxit=500,trace=1))
str(fit)
}
}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
