% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbosity_level.R
\name{get_verbosity_level}
\alias{get_verbosity_level}
\title{Get verbosity level}
\usage{
get_verbosity_level(.envir = sys.function(which = -1))
}
\arguments{
\item{.envir}{Environment in which the options are defined.
Default is suitable for use inside your package.}
}
\value{
\verb{[character(1)]} representing the verbosity level.
}
\description{
This function retrieves the \code{verbosity_level} for your environment using the
priority hierarchy as described in \link{verbosity_level}.

While the examples use \code{zephyr}, this function works with any package,
and inside a package it is not necessary to specify it; the default value
of \code{.envir} is enough.

It is normally not relevant to query the \code{verbosity_level} yourself. Instead
use the appropriate \link{msg} function.
}
\examples{
# Get the verbosity level
# Note: Specifying the environment is not needed when used inside a package
get_verbosity_level("zephyr")

# Temporarily change verbosity level using an environment variable
withr::with_envvar(
  new = c("R_ZEPHYR_VERBOSITY_LEVEL" = "quiet"),
  code = get_verbosity_level("zephyr")
)

# Temporarily change verbosity level using an option value
withr::with_options(
  new = c("zephyr.verbosity_level" = "minimal"),
  code = get_verbosity_level("zephyr")
)

}
