% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot1dgrid.R
\name{rug_1d_grid}
\alias{rug_1d_grid}
\title{Rug plot in 1d using the grid package}
\usage{
rug_1d_grid(zargs, loc = 0.5, length = 0.5, width = 0.001,
  col = par("fg"), draw = FALSE, ...)
}
\arguments{
\item{zargs}{argument list as passed from \code{\link{zenplot}()}}

\item{loc}{location in [0,1]; 0 corresponds to left, 1 to right (in
the direction of the path)}

\item{length}{length of the rugs}

\item{width}{line width of the rugs}

\item{col}{default color of the rectangles/rugs}

\item{draw}{logical indicating whether drawing should take place}

\item{...}{additional arguments passed to gpar()}
}
\value{
grob (invisibly)
}
\description{
Rug plot in 1d using the grid package
}
\note{
The choice of width and height is to leave the rugs enough space to not
      touch points (so to avoid points and rugs overplotting).
}
\seealso{
Other default 1d plot functions using the grid package: \code{\link{arrow_1d_grid}},
  \code{\link{boxplot_1d_grid}},
  \code{\link{density_1d_grid}},
  \code{\link{hist_1d_grid}}, \code{\link{jitter_1d_grid}},
  \code{\link{label_1d_grid}}, \code{\link{lines_1d_grid}},
  \code{\link{points_1d_grid}}, \code{\link{rect_1d_grid}}

Other default 1d plot functions: \code{\link{arrow_1d_graphics}},
  \code{\link{arrow_1d_grid}}, \code{\link{arrow_1d_loon}},
  \code{\link{boxplot_1d_graphics}},
  \code{\link{boxplot_1d_grid}},
  \code{\link{boxplot_1d_loon}},
  \code{\link{density_1d_graphics}},
  \code{\link{density_1d_grid}},
  \code{\link{density_1d_loon}}, \code{\link{extract_1d}},
  \code{\link{hist_1d_graphics}},
  \code{\link{hist_1d_grid}}, \code{\link{hist_1d_loon}},
  \code{\link{jitter_1d_graphics}},
  \code{\link{jitter_1d_grid}},
  \code{\link{jitter_1d_loon}},
  \code{\link{label_1d_graphics}},
  \code{\link{label_1d_grid}}, \code{\link{label_1d_loon}},
  \code{\link{lines_1d_graphics}},
  \code{\link{lines_1d_grid}}, \code{\link{lines_1d_loon}},
  \code{\link{points_1d_graphics}},
  \code{\link{points_1d_grid}},
  \code{\link{points_1d_loon}},
  \code{\link{rect_1d_graphics}},
  \code{\link{rect_1d_grid}}, \code{\link{rect_1d_loon}},
  \code{\link{rug_1d_graphics}}, \code{\link{rug_1d_loon}}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 1d plot functions}
\concept{default 1d plot functions using the grid package}
