% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zcurve_density.R
\name{control_density}
\alias{control_density}
\title{Control settings for the z-curve 2.0 density algorithm}
\arguments{
\item{version}{Which version of z-curve should be fitted. Defaults to
\code{2} = z-curve 2.0. Set to \code{1} in order to fit the original
version of z-curve. For its settings page go to \link{control_density_v1}.}

\item{model}{A type of model to be fitted, defaults to \code{"KD2"}
(another possibility is \code{"KD1"} for the original z-curve 1.0, see
\link{control_density_v1} for its settings)}

\item{sig_level}{An alpha level of the test statistics, defaults to
\code{.05}}

\item{a}{A beginning of fitting interval, defaults to
\code{qnorm(sig_level/2,lower.tail = F)}}

\item{b}{An end of fitting interval, defaults to \code{6}}

\item{mu}{Means of the components, defaults to \code{seq(0,6,1)}}

\item{sigma}{A standard deviation of the components, "Don't touch this"
\- Ulrich Schimmack, defaults to \code{1}}

\item{theta_min}{Lower limits for weights, defaults to
\code{rep(0,length(mu))}}

\item{theta_max}{Upper limits for weights, defaults to
\code{rep(1,length(mu))}}

\item{max_iter}{A maximum number of iterations for the \link[stats]{nlminb}
optimization for fitting mixture model, defaults to \code{150}}

\item{max_eval}{A maximum number of evaluation for the \link[stats]{nlminb}
optimization for fitting mixture model, defaults to \code{1000}}

\item{criterion}{A criterion to terminate \link[stats]{nlminb} optimization,
defaults to \code{1e-03}}

\item{bw}{A bandwidth of the kernel density estimation, defaults to \code{.10}}

\item{aug}{Augment truncated kernel density, defaults to \code{TRUE}}

\item{aug.bw}{A bandwidth of the augmentation, defaults to \code{.20}}

\item{n.bars}{A resolution of density function, defaults to \code{512}}

\item{density_dbc}{Use \link[evmix]{bckden} to estimate a truncated kernel density,
defaults to \code{FALSE}, in which case \link[stats]{density} is used}

\item{compute_FDR}{Whether to compute FDR, leads to noticeable increase in
computation, defaults to \code{FALSE}}

\item{criterion_FDR}{A criterion for estimating the maximum FDR, defaults
to \code{.02}}

\item{criterion_FDR_dbc}{A criterion for estimating the maximum FDR using
the \link[evmix]{bckden} function, defaults to \code{.01}}

\item{precision_FDR}{A maximum FDR precision, defaults to \code{.05}}
}
\description{
All settings are passed to the density fitting
algorithm. All unspecified settings are set to the default value.
Setting \code{model = "KD2"} sets all settings to the default
value irrespective of any other setting and fits z-curve as
describe in \insertCite{zcurve2;textual}{zcurve}. In order to fit the
z-curve 1.0 density algorithm, set \code{model = "KD1"} and go to
\link{control_density_v1}
}
\examples{
# to decrease the criterion and increase the number of iterations
ctrl <- list(
   max_iter  = 300,
   criterion = 1e-4
)
\donttest{zcurve(OSC.z, method = "density", control = ctrl)}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=zcurve]{zcurve()}}, \link{control_density_v1}, \link{control_EM}
}
