% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.R
\name{ypr_population}
\alias{ypr_population}
\title{Population Parameters}
\usage{
ypr_population(tmax = 20L, k = 0.15, Linf = 100, t0 = 0, Wb = 3,
  Ls = Linf/2, Sp = 100, es = 1, Sm = 0, fb = 1, tR = 1L,
  BH = 1L, Rk = 3, M = 0.2, Mb = 0, Lv = Linf/2, Vp = 100,
  Llo = 0, Lup = Linf, Nc = 0, pi = 0.2, rho = 0, Hm = 0,
  Rmax = 1, A0 = 0, Wa = 0.01, fa = 1, q = 0.1)
}
\arguments{
\item{tmax}{The maximum age (yr).}

\item{k}{The VB growth coefficient (per yr).}

\item{Linf}{The VB mean maximum length (cm).}

\item{t0}{The (theoretical) age at zero length (yr).}

\item{Wb}{The weight (as a function of length) scaling exponent.}

\item{Ls}{The length at which 50\% mature (cm).}

\item{Sp}{The maturity (as a function of length) power.}

\item{es}{The annual probability of a mature fish spawning.}

\item{Sm}{The spawning mortality probability.}

\item{fb}{The fecundity (as a function of weight) scaling exponent.}

\item{tR}{The age from which survival is density-independent (yr).}

\item{BH}{Recruitment follows a Beverton-Holt (1) or Ricker (0) relationship.}

\item{Rk}{The lifetime spawners per spawner at low density.}

\item{M}{The instantaneous mortality rate (per yr).}

\item{Mb}{The instantaneous mortality rate (as a function of length) scaling exponent.}

\item{Lv}{The length at which 50\% vulnerable to harvest (cm).}

\item{Vp}{The vulnerability to harvest (as a function of length) power.}

\item{Llo}{The lower harvest slot length (cm).}

\item{Lup}{The upper harvest slot length (cm).}

\item{Nc}{The slot limits non-compliance probability.}

\item{pi}{The annual capture probability.}

\item{rho}{The release probability.}

\item{Hm}{The hooking mortality probability.}

\item{Rmax}{The number of recruits at the carrying capacity (ind).}

\item{A0}{The initial post age tR density independent mortality probability.}

\item{Wa}{The (extrapolated) weight of a 1 cm individual (g).}

\item{fa}{The (theoretical) fecundity of a 1 g female (eggs).}

\item{q}{The catchability (annual probability of capture) for a unit of effort.}
}
\value{
An object of class \code{ypr_population}.
}
\description{
Generates an object of class \code{ypr_population}.
}
\examples{
ypr_population(k = 0.1, Linf = 90)
}
\seealso{
\code{\link{ypr_population_update}}, \code{\link{ypr_schedule}},
\code{\link{ypr_yield}} and \code{\link{ypr_optimize}}.
}
