% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{ypr_plot_yield.ypr_population}
\alias{ypr_plot_yield.ypr_population}
\title{Plot Yield by Exploitation/Capture Probability}
\usage{
\method{ypr_plot_yield}{ypr_population}(object, y = "Yield",
  pi = seq(0, 1, length.out = 100), Ly = 0, harvest = TRUE,
  biomass = FALSE, u = harvest, plot_values = TRUE, ...)
}
\arguments{
\item{object}{The populations or populations.}

\item{y}{A string of the term on the y-axis.}

\item{pi}{A vector of probabilities of capture to calculate the yield for.}

\item{Ly}{The minimum length (trophy) fish to consider when calculating the yield.}

\item{harvest}{A flag indicating whether to calculate the yield for harvested fish or captures.}

\item{biomass}{A flag indicating whether to calculate the yield in terms of the biomass versus number of individuals.}

\item{u}{A flag indicating whether to plot the exploitation rate as opposed to the capture rate.}

\item{plot_values}{A flag indicating whether to plot the actual and optimal values.}

\item{...}{Unused parameters.}
}
\value{
A ggplot2 object.
}
\description{
Plots the 'Yield', 'Age', 'Length', 'Weight', 'Effort', or 'YPUE'
by the annual interval exploitation/capture probability.
}
\examples{
ypr_plot_yield(ypr_population())
}
\seealso{
\code{\link{ypr_population}} and \code{\link{ypr_yields}}
}
