% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv-concordance_survival.R
\name{concordance_survival}
\alias{concordance_survival}
\alias{concordance_survival.data.frame}
\alias{concordance_survival_vec}
\title{Concordance index for right-censored data}
\usage{
concordance_survival(data, ...)

\method{concordance_survival}{data.frame}(
  data,
  truth,
  estimate,
  na_rm = TRUE,
  case_weights = NULL,
  ...
)

concordance_survival_vec(
  truth,
  estimate,
  na_rm = TRUE,
  case_weights = NULL,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by \code{truth} and
\code{...}.}

\item{...}{Currently not used.}

\item{truth}{The column identifier for the true survival result (that
is created using \code{\link[survival:Surv]{survival::Surv()}}.). This should be an unquoted column name
although this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column names). For
\verb{_vec()} functions, an \code{\link[survival:Surv]{survival::Surv()}} object.}

\item{estimate}{The column identifier for the predicted time, this should be
a numeric variables. This should be an unquoted column name although this
argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column names). For
\verb{_vec()} functions, a numeric vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights.
This should be an unquoted column name that evaluates to a numeric column
in \code{data}. For \verb{_vec()} functions, a numeric vector,
\code{\link[hardhat:importance_weights]{hardhat::importance_weights()}}, or \code{\link[hardhat:frequency_weights]{hardhat::frequency_weights()}}.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{concordance_survival_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Compute the Concordance index for right-censored data
}
\details{
The concordance index is defined as the proportion of all comparable pairs in
which the predictions and outcomes are concordant.

Two observations are comparable if:
\enumerate{
\item both of the observations experienced an event (at different times), or
\item the observation with the shorter observed survival time experienced an
event, in which case the event-free subject “outlived” the other.
}

A pair is not comparable if they experienced events at the same time.

Concordance intuitively means that two samples were ordered correctly by the
model. More specifically, two samples are concordant, if the one with a
higher estimated risk score has a shorter actual survival time.

Larger values of the score are associated with better model performance.
}
\examples{
concordance_survival(
  data = lung_surv,
  truth = surv_obj,
  estimate = .pred_time
)
}
\references{
Harrell, F.E., Califf, R.M., Pryor, D.B., Lee, K.L., Rosati, R.A,
“Multivariable prognostic models: issues in developing models, evaluating
assumptions and adequacy, and measuring and reducing errors”, Statistics in
Medicine, 15(4), 361-87, 1996.
}
\author{
Emil Hvitfeldt
}
\concept{static survival metrics}
