% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob-mn_log_loss.R
\name{mn_log_loss}
\alias{mn_log_loss}
\alias{mn_log_loss.data.frame}
\alias{mn_log_loss_vec}
\title{Mean log loss}
\usage{
mn_log_loss(data, ...)

\method{mn_log_loss}{data.frame}(data, truth, ..., na_rm = TRUE, sum = FALSE)

mn_log_loss_vec(truth, estimate, na_rm = TRUE, sum = FALSE, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the \code{truth} and \code{estimate}
columns.}

\item{...}{A set of unquoted column names or one or more
\code{dplyr} selector functions to choose which variables contain the
class probabilities. If \code{truth} is binary, only 1 column should be selected.
Otherwise, there should be as many columns as factor levels of \code{truth}.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{factor} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{sum}{A \code{logical}. Should the sum of the likelihood contributions be
returned (instead of the mean value)?}

\item{estimate}{If \code{truth} is binary, a numeric vector of class probabilities
corresponding to the "relevant" class. Otherwise, a matrix with as many
columns as factor levels of \code{truth}. \emph{It is assumed that these are in the
same order as the levels of \code{truth}.}}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{mn_log_loss_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Compute the logarithmic loss of a classification model.
}
\details{
Log loss is a measure of the performance of a classification model. A
perfect model has a log loss of \code{0}.

Compared with \code{\link[=accuracy]{accuracy()}}, log loss
takes into account the uncertainty in the prediction and gives a more
detailed view into the actual performance. For example, given two input
probabilities of \code{.6} and \code{.9} where both are classified as predicting
a positive value, say, \code{"Yes"}, the accuracy metric would interpret them
as having the same value. If the true output is \code{"Yes"}, log loss penalizes
\code{.6} because it is "less sure" of it's result compared to the probability
of \code{.9}.
}
\section{Multiclass}{

Log loss has a known multiclass extension, and is simply the sum of the
log loss values for each class prediction. Because of this, no averaging
types are supported.
}

\examples{
# Two class
data("two_class_example")
mn_log_loss(two_class_example, truth, Class1)

# Multiclass
library(dplyr)
data(hpc_cv)

# You can use the col1:colN tidyselect syntax
hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  mn_log_loss(obs, VF:L)

# Groups are respected
hpc_cv \%>\%
  group_by(Resample) \%>\%
  mn_log_loss(obs, VF:L)


# Vector version
# Supply a matrix of class probabilities
fold1 <- hpc_cv \%>\%
  filter(Resample == "Fold01")

mn_log_loss_vec(
   truth = fold1$obs,
   matrix(
     c(fold1$VF, fold1$F, fold1$M, fold1$L),
     ncol = 4
   )
)

# Supply `...` with quasiquotation
prob_cols <- levels(two_class_example$truth)
mn_log_loss(two_class_example, truth, Class1)
mn_log_loss(two_class_example, truth, !! prob_cols[1])

}
\seealso{
Other class probability metrics: 
\code{\link{average_precision}()},
\code{\link{gain_capture}()},
\code{\link{pr_auc}()},
\code{\link{roc_auc}()}
}
\author{
Max Kuhn
}
\concept{class probability metrics}
