% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimator-helpers.R, R/prob-helpers.R,
%   R/validation.R
\name{get_weights}
\alias{get_weights}
\alias{finalize_estimator}
\alias{finalize_estimator_internal}
\alias{developer-helpers}
\alias{dots_to_estimate}
\alias{validate_estimator}
\title{Developer helpers}
\usage{
get_weights(data, estimator)

finalize_estimator(x, estimator = NULL, metric_class = "default")

finalize_estimator_internal(metric_dispatcher, x, estimator)

dots_to_estimate(data, ...)

validate_estimator(estimator, estimator_override = NULL)
}
\arguments{
\item{data}{A table with truth values as columns and predicted values
as rows.}

\item{estimator}{Either \code{NULL} for auto-selection, or a single character
for the type of estimator to use.}

\item{x}{The column used to autoselect the estimator. This is generally
the \code{truth} column, but can also be a table if your metric has table methods.}

\item{metric_class}{A single character of the name of the metric to autoselect
the estimator for. This should match the method name created for
\code{finalize_estimator_internal()}.}

\item{metric_dispatcher}{A simple dummy object with the class provided to
\code{metric_class}. This is created and passed along for you.}

\item{...}{A set of unquoted column names or one or more
\code{dplyr} selector functions to choose which variables contain the
class probabilities. If \code{truth} is binary, only 1 column should be selected.
Otherwise, there should be as many columns as factor levels of \code{truth}.}

\item{estimator_override}{A character vector overriding the default allowed
estimator list of \code{c("binary", "macro", "micro", "macro_weighted")}. Set
this is your classification estimator does not support all of these methods.}
}
\description{
Helpers to be used alongside \code{\link[=metric_vec_template]{metric_vec_template()}} and \code{\link[=metric_summarizer]{metric_summarizer()}}
when creating new metrics. See \code{vignette("custom-metrics", "yardstick")} for
more information.
}
\section{Weight Calculation}{

\code{get_weights()} accepts a confusion matrix and an \code{estimator} of type
\code{"macro"}, \code{"micro"}, or \code{"macro_weighted"} and returns the correct weights.
It is useful when creating multiclass metrics.
}

\section{Estimator Selection}{


\code{finalize_estimator()} is the engine for auto-selection of \code{estimator} based
on the type of \code{x}. Generally \code{x} is the \code{truth} column. This function
is called from the vector method of your metric.

\code{finalize_estimator_internal()} is an S3 generic that you should extend for
your metric if it does not implement \emph{only} the following estimator types:
\code{"binary"}, \code{"macro"}, \code{"micro"}, and \code{"macro_weighted"}. If your metric
does support all of these, the default version of
\code{finalize_estimator_internal()} will autoselect \code{estimator} appropriately.
If you need to create a method, it should take the form:
\code{finalize_estimator_internal.metric_name}. Your method for
\code{finalize_estimator_internal()} should do two things:
\enumerate{
\item If \code{estimator} is \code{NULL}, autoselect the \code{estimator} based on the
type of \code{x} and return a single character for the \code{estimator}.
\item If \code{estimator} is not \code{NULL}, validate that it is an allowed \code{estimator}
for your metric and return it.
}

If you are using the default for \code{finalize_estimator_internal()}, the
\code{estimator} is selected using the following heuristics:
\enumerate{
\item If \code{estimator} is not \code{NULL}, it is validated and returned immediately
as no auto-selection is needed.
\item If \code{x} is a:
\itemize{
\item \code{factor} - Then \code{"binary"} is returned if it has 2 levels, otherwise
\code{"macro"} is returned.
\item \code{numeric} - Then \code{"binary"} is returned.
\item \code{table} - Then \code{"binary"} is returned if it has 2 columns, otherwise
\code{"macro"} is returned. This is useful if you have \code{table} methods.
\item \code{matrix} - Then \code{"macro"} is returned.
}
}
}

\section{Dots -> Estimate}{


\code{dots_to_estimate()} is useful with class probability metrics that take
\code{...} rather than \code{estimate} as an argument. It constructs either a single
name if 1 input is provided to \code{...} or it constructs a quosure where the
expression constructs a matrix of as many columns as are provided to \code{...}.
These are eventually evaluated in the \code{summarise()} call in
\code{\link[=metric_summarizer]{metric_summarizer()}} and evaluate to either a vector or a matrix for further
use in the underlying vector functions.
}

\section{Estimator Validation}{

\code{validate_estimator()} is called from your metric specific method of
\code{finalize_estimator_internal()} and ensures that a user provided estimator
is of the right format and is one of the allowed values.
}

\seealso{
\code{\link[=metric_summarizer]{metric_summarizer()}} \code{\link[=metric_vec_template]{metric_vec_template()}}
}
