% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probs.R
\name{roc_auc}
\alias{roc_auc}
\alias{roc_auc.default}
\alias{pr_auc}
\alias{pr_auc.default}
\alias{roc_auc.data.frame}
\alias{pr_auc}
\alias{pr_auc.data.frame}
\alias{mnLogLoss}
\alias{mnLogLoss.data.frame}
\title{Metrics Based on Class Probabilities}
\usage{
roc_auc(data, ...)

\method{roc_auc}{data.frame}(data, truth, ..., options = list(),
  na.rm = TRUE)

pr_auc(data, ...)

\method{pr_auc}{data.frame}(data, truth, ..., na.rm = TRUE)

mnLogLoss(data, ...)

\method{mnLogLoss}{data.frame}(data, truth, ..., na.rm = TRUE, sum = FALSE)
}
\arguments{
\item{data}{A data frame with the relevant columns.}

\item{...}{A set of unquoted column names or one or more
\code{dplyr} selector functions to choose which variables contain the
class probabilities. See the examples below. For \code{roc_auc} and
\code{pr_auc}, only one value is required. If more are given, the
functions will try to match the column name to the appropriate
factor level of \code{truth}. If this doesn't work, an error is
thrown. For \code{mnLogLoss}, there should be as many columns as
factor levels of \code{truth}. It is \strong{assumed} that they are in the
same order as the factor levels.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should an unquoted column name although
this argument is passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{options}{Options to pass to \code{\link[=roc]{roc()}} such as \code{direction} or
\code{smooth}. These options should not include \code{response},
\code{predictor}, or \code{levels}.}

\item{na.rm}{A logical value indicating whether \code{NA}
values should be stripped before the computation proceeds}

\item{sum}{A logical. Should the sum of the likelihood
contrinbutions be returned (instead of the mean value)?}
}
\value{
A number between 0 and 1 (or NA) for \code{roc_auc} or
\code{pr_auc}. For \code{mnLogLoss} a number or \code{NA}.
}
\description{
These functions compute the areas under the receiver operating
characteristic (ROC) curve (\code{roc_auc}), the precision-recall
curve (\code{pr_auc}), or the multinomial log loss (\code{mnLogLoss}).
}
\details{
There is no common convention on which factor level should
automatically be considered the "relevant" or "positive" results.
In \code{yardstick}, the default is to use the \emph{first} level. To
change this, a global option called \code{yardstick.event_first} is
set to \code{TRUE} when the package is loaded. This can be changed
to \code{FALSE} if the last level of the factor is considered the
level of interest.
}
\examples{
library(tidyselect)

data("two_class_example")
prob_cols <- levels(two_class_example$truth)

roc_auc(two_class_example, truth = truth, Class1)
# warning is issued here because 2 columns are selected:
roc_auc(two_class_example, truth, starts_with("Class"))

# passing options via a list and _not_ `...`
roc_auc(two_class_example, truth = "truth", Class1,
        options = list(smooth = TRUE))
        
pr_auc(two_class_example, truth, prob_cols)    

mnLogLoss(two_class_example, truth, starts_with("Class"))
# or
mnLogLoss(two_class_example, truth, !! prob_cols)            
}
\seealso{
\code{\link[=conf_mat]{conf_mat()}}, \code{\link[=summary.conf_mat]{summary.conf_mat()}}, \code{\link[=recall]{recall()}}, \code{\link[=mcc]{mcc()}}
}
\keyword{manip}
