#' Calculate a matrix of predicted probabilities 
#'
#' The function \code{pnn.predict} calculates a matrix of predicted probabilities based on a matrix of predictors
#'
#' @param net The PNN object generated by pnn.fit() 
#' @param x   The matrix of input predictors 
#'
#' @return A matrix of predicted probabilities for all categories
#'
#' @seealso \code{\link{pnn.predone}}
#'
#' @examples
#' data(iris, package = "datasets")
#' Y <- iris[, 5]
#' X <- scale(iris[, 1:4])
#' pnet <- pnn.fit(x = X, y = Y)
#' pnn.predict(pnet, X[seq(5), ])

pnn.predict <- function(net, x) {
  if (class(net) != "Probabilistic Neural Net") stop("net needs to be a PNN object.", call. = F)
  if (is.matrix(x) == F) stop("x needs to be a matrix.", call. = F)
  if (anyNA(x) == T) stop("NA found in x.", call. = F)
  if (ncol(x) != ncol(net$x)) stop("x dimension is not consistent with grnn.", call. = F)

  return(Reduce(rbind, lapply(split(x, seq(nrow(x))), function(x_) pnn.predone(net, x_))))
}
