% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_csv.R
\name{io_csv.data.frame}
\alias{io_csv.data.frame}
\title{Export Documented Table as CSV}
\usage{
\method{io_csv}{data.frame}(
  x,
  file = "",
  ext = getOption("yamlet_extension", ".yaml"),
  coerce = getOption("yamlet_coerce_decorations", FALSE),
  con = stdout(),
  useBytes = FALSE,
  default_keys = getOption("yamlet_default_keys", list("label", "guide")),
  ...
)
}
\arguments{
\item{x}{data.frame}

\item{file}{passed to \code{\link[csv]{as.csv.data.frame}} (by method dispatch)}

\item{ext}{= extension for metadata equivalent of x}

\item{coerce}{logical; whether to coerce factor levels to guide; alternatively, a key for the levels}

\item{con}{passed to \code{\link{io_yamlet}}}

\item{useBytes}{passed to \code{\link{io_yamlet}}}

\item{default_keys}{passed to \code{\link{io_yamlet}}}

\item{...}{passed to \code{\link{write.table}} and to \code{\link{io_yamlet}}}
}
\value{
invisible(file)
}
\description{
Exports a data.frame as comma-separated variable,
as well as a yamlet version of its decorations.
A wrapper for \code{\link[csv]{as.csv.data.frame}}.
}
\examples{
example(io_table)
}
\seealso{
Other io: 
\code{\link{io_csv.character}()},
\code{\link{io_csv}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_table}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()},
\code{\link{io_yamlet}()}

Other interface: 
\code{\link{decorate.character}()},
\code{\link{decorate.list}()},
\code{\link{decorate}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_table}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()},
\code{\link{io_yamlet}()},
\code{\link{read_yamlet}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{io}
