% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{as_yamlet.character}
\alias{as_yamlet.character}
\title{Coerce Character To Yamlet Format}
\usage{
\method{as_yamlet}{character}(
  x,
  default_keys = getOption("yamlet_default_keys", list("label", "guide")),
  ...
)
}
\arguments{
\item{x}{length-one filepath or actual data}

\item{default_keys}{character: default keys for the first n anonymous members of each element}

\item{...}{passed to \code{\link{as_yam.character}} and \code{\link{as_yamlet.yam}}}
}
\value{
yamlet: a named list with default keys applied
}
\description{
Coerces character to yamlet format.
Length-one character is understood as a file path
if the file exists.  Otherwise, it is treated as data.
The file is a mapping of (nested) sequences,
where map keys are data item names, and
sequences represent data item attributes.
Attributes may be named or anonymous.
}
\details{
If an attribute is anonymous, an attempt
is made to name it using available defaults.
A special item named '_keys' if present identifies a sequence of
key names that over-ride \code{default_keys}.
Attribute names are sought first in the explicit yaml,
then in the special item named '_keys',
then in the \code{default_keys} argument passed to \code{\link{as_yamlet}},
then in \code{options()$yamlet_default_keys},
then in the defaults for argument \code{default_keys}.
}
\examples{
file <- system.file(package = 'yamlet', 'extdata','quinidine.yaml')
as_yamlet(file)
as_yamlet('ID: subject identifier')
as_yamlet(c('id: subject','amt: dose'))
as_yamlet(c('id: subject\namt: dose'))

}
\seealso{
Other yamlet: 
\code{\link{as_yamlet.yam}()},
\code{\link{as_yamlet}()},
\code{\link{print.yamlet}()}
}
\concept{yamlet}
