% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/util.R
\name{EstimateExpression}
\alias{EstimateExpression}
\title{A mixture modelling approach to estiamte whether a gene is expressed in a study
 given RNA-seq gene expression data}
\usage{
EstimateExpression(expr, show.plot = FALSE, loglik = TRUE,
  xlab = "Expression", ylab = "Density", ...)
}
\arguments{
\item{expr}{A matrix of RNA-seq gene expression values where
each row corresponds to a patient and each column is a gene.
Typically the expression of each gene is the log2 transformed RSEM value.}

\item{show.plot}{Logical, specifying whether to plot results}

\item{loglik}{Logical, whether plot the log-likelihoods}

\item{xlab}{xlab of the plot}

\item{ylab}{ylab of the plot}

\item{...}{Arguments for plotting}
}
\value{
A weight vector representing whether individual genes
are expressed in the study
}
\description{
A mixture modelling approach to estiamte whether a gene is expressed in a study
 given RNA-seq gene expression data
}
\examples{
data(expr)
weight = EstimateExpression(expr)
}

