library(xpectr)
context("dputSelectedAddin()")

test_that("testing dputSelectedAddin()", {
  xpectr::set_test_seed(42)

  v <- c(1,2,3)
  f <- function(a,b){a+b}

  # dputSelectedAddin(selection = NULL, insert = TRUE, indentation = 0)
  xpectr::set_test_seed(42)
  # gxs_function(dputSelectedAddin, args_values = list(
  #   "selection" = list("v", "f", "f()", NA, 1, "h"),
  #   "insert" = list(FALSE, NA, "hej"),
  #   "indentation" = list(0, 3, -1, NA, "0")
  # ), indentation = 2)

  ## Testing 'dputSelectedAddin'                                              ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing dputSelectedAddin(selection = "v", insert = ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- dputSelectedAddin(selection = "v", insert = FALSE, indentation = 0)
  # Testing class
  expect_equal(
    class(output_19148),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "character")
  # Testing values
  expect_equal(
    output_19148,
    "c(1, 2, 3)",
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    1L)

  # Testing dputSelectedAddin(selection = "f", insert = ...
  # Changed from baseline: selection = "f"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- dputSelectedAddin(selection = "f", insert = FALSE, indentation = 0)
  # Testing class
  expect_equal(
    class(output_19370),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19370,
    type = "character")
  # Testing values
  expect_equal(
    output_19370,
    c("function (a, b) ", "{", "    a + b", "}"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19370),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19370),
    4L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19370)),
    4L)

  # Testing dputSelectedAddin(selection = "f()", insert ...
  # Changed from baseline: selection = "f()"
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(dputSelectedAddin(selection = "f()", insert = FALSE, indentation = 0)),
    xpectr::strip("argument \"a\" is missing, with no default"),
    fixed = TRUE)

  # Testing dputSelectedAddin(selection = NA, insert = F...
  # Changed from baseline: selection = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(dputSelectedAddin(selection = NA, insert = FALSE, indentation = 0)),
    xpectr::strip("1 assertions failed:\n * Variable 'selection': May not be NA."),
    fixed = TRUE)

  # Testing dputSelectedAddin(selection = 1, insert = FA...
  # Changed from baseline: selection = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(dputSelectedAddin(selection = 1, insert = FALSE, indentation = 0)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'selection': Must be of t",
                         "ype 'string' (or 'NULL'), not 'double'.")),
    fixed = TRUE)

  # Testing dputSelectedAddin(selection = "h", insert = ...
  # Changed from baseline: selection = "h"
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(dputSelectedAddin(selection = "h", insert = FALSE, indentation = 0)),
    xpectr::strip("object 'h' not found"),
    fixed = TRUE)

  # Testing dputSelectedAddin(selection = NULL, insert =...
  # Changed from baseline: selection = NULL
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(dputSelectedAddin(selection = NULL, insert = FALSE, indentation = 0)))

  # Testing dputSelectedAddin(selection = "v", insert = ...
  # Changed from baseline: insert = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(dputSelectedAddin(selection = "v", insert = NA, indentation = 0)),
    xpectr::strip("1 assertions failed:\n * Variable 'insert': May not be NA."),
    fixed = TRUE)

  # Testing dputSelectedAddin(selection = "v", insert = ...
  # Changed from baseline: insert = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(dputSelectedAddin(selection = "v", insert = "hej", indentation = 0)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'insert': Must be of type",
                         " 'logical flag', not 'character'.")),
    fixed = TRUE)

  # Testing dputSelectedAddin(selection = "v", insert = ...
  # Changed from baseline: insert = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(dputSelectedAddin(selection = "v", insert = NULL, indentation = 0)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'insert': Must be of type",
                         " 'logical flag', not 'NULL'.")),
    fixed = TRUE)

  # Testing dputSelectedAddin(selection = "v", insert = ...
  # Changed from baseline: indentation = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(dputSelectedAddin(selection = "v", insert = FALSE, indentation = NA)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'indentation': Contains m",
                         "issing values (element 1).")),
    fixed = TRUE)

  # Testing dputSelectedAddin(selection = "v", insert = ...
  # Changed from baseline: indentation = "0"
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(dputSelectedAddin(selection = "v", insert = FALSE, indentation = "0")),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'indentation': Must be of",
                         " type 'integerish' (or 'NULL'), not 'character'.")),
    fixed = TRUE)

  # Testing dputSelectedAddin(selection = "v", insert = ...
  # Changed from baseline: indentation = 3
  xpectr::set_test_seed(42)
  # Assigning output
  output_19346 <- dputSelectedAddin(selection = "v", insert = FALSE, indentation = 3)
  # Testing class
  expect_equal(
    class(output_19346),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19346,
    type = "character")
  # Testing values
  expect_equal(
    output_19346,
    "c(1, 2, 3)",
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19346),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19346),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19346)),
    1L)

  # Testing dputSelectedAddin(selection = "v", insert = ...
  # Changed from baseline: indentation = -1
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(dputSelectedAddin(selection = "v", insert = FALSE, indentation = -1)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'indentation': Element 1 ",
                         "is not >= 0.")),
    fixed = TRUE)

  # Testing dputSelectedAddin(selection = "v", insert = ...
  # Changed from baseline: indentation = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- dputSelectedAddin(selection = "v", insert = FALSE, indentation = NULL)
  # Testing class
  expect_equal(
    class(output_14622),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14622,
    type = "character")
  # Testing values
  expect_equal(
    output_14622,
    "c(1, 2, 3)",
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_14622),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_14622),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_14622)),
    1L)

  ## Finished testing 'dputSelectedAddin'                                     ####
  #

})
