% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bookmarks.R
\name{cat_bookmarks}
\alias{cat_bookmarks}
\title{Concatenate pdf bookmarks}
\usage{
cat_bookmarks(
  l,
  method = c("flat", "filename", "title"),
  open = NA,
  color = NA_character_,
  fontface = NA_character_
)
}
\arguments{
\item{l}{A list of bookmark data frames as returned by \code{\link[=get_bookmarks]{get_bookmarks()}}.
Each data frame should have a "total_pages" attribute.
If \code{method = "filename"} each data frame should have a "filename" attribute.
If \code{method = "title"} each data frame should have a "title" attribute.}

\item{method}{If "flat" simply concatenate the bookmarks while updating page numbers.
If "filename" place each file's bookmarks a level under a new bookmark matching
the (base)name of the filename and then concatenate the bookmarks while updating page numbers.
If "title" place each file's bookmarks a level under a new bookmark matching
the title of the file and then concatenate the bookmarks while updating page numbers.}

\item{open}{If \code{method = "filename"} or \code{method = "title"} a logical for whether the new top level bookmarks should start open?
If missing will default to open.
Note some pdf viewers quietly ignore the initially open/closed feature.}

\item{color}{If \code{method = "filename"} or \code{method = "title"} the color of the new top level bookmarks.
If \code{NA_character_} will be unset (presumably defaults to "black").
Note many pdf viewers quietly ignore this feature.}

\item{fontface}{If \code{method = "filename"} or \code{method = "title"} should the fontface of the new top level bookmarks.
If \code{NA_character_} or \code{NA_integer_} will be unset (defaults to "plain").
"plain" or 1 is plain, "bold" or 2 is bold, "italic" or 3 is italic,
Note many pdf viewers quietly ignore this feature.}
}
\value{
A data frame of bookmark data (as suitable for use with \code{\link[=set_bookmarks]{set_bookmarks()}}).
A "total_pages" attribute will be set for the theoretical total pages of
the concatenated document represented by the concatenated bookmarks.
}
\description{
\code{cat_bookmarks()} concatenates a list of bookmarks
into a single bookmarks data frame while updating the page numbers.
Useful if wanting to concatenate multiple pdf files together and
would like to preserve the bookmarks information.
}
\examples{
if (supports_get_bookmarks() && supports_set_bookmarks() && require("grid", quietly = TRUE)) {
 # Create two different two-page pdf files
 make_pdf <- function(f, title) {
   pdf(f, onefile = TRUE, title = title)
   grid.text(paste(title, "Page 1"))
   grid.newpage()
   grid.text(paste(title, "Page 2"))
   invisible(dev.off())
 }
 f1 <- tempfile(fileext = "_doc1.pdf")
 on.exit(unlink(f1))
 make_pdf(f1, "Document 1")

 f2 <- tempfile(fileext = "_doc2.pdf")
 on.exit(unlink(f2))
 make_pdf(f2, "Document 2")

 # Add bookmarks to the two two-page pdf files
 bookmarks <- data.frame(title = c("Page 1", "Page 2"),
                         page = c(1L, 2L))
 set_bookmarks(bookmarks, f1)
 set_bookmarks(bookmarks, f2)
 l <- get_bookmarks(c(f1, f2))
 print(l)

 bm <- cat_bookmarks(l, method = "flat")
 cat('\nmethod = "flat":\n')
 print(bm)

 bm <- cat_bookmarks(l, method = "filename")
 cat('\nmethod = "filename":\n')
 print(bm)

 bm <- cat_bookmarks(l, method = "title")
 cat('\nmethod = "title":\n')
 print(bm)

 # `cat_bookmarks()` is useful for setting concatenated pdf files
 # created with `cat_pages()`
 if (supports_cat_pages()) {
    fc <- tempfile(fileext = "_cat.pdf")
    on.exit(unlink(fc))
    cat_pages(c(f1, f2), fc)
    set_bookmarks(bm, fc)
    unlink(fc)
 }

 unlink(f1)
 unlink(f2)
}
}
\seealso{
\code{\link[=get_bookmarks]{get_bookmarks()}} and \code{\link[=set_bookmarks]{set_bookmarks()}} for setting bookmarks.
\code{\link[=cat_pages]{cat_pages()}} for concatenating pdf files together.
}
