% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_scale_x_time_units.R
\name{xgx_scale_x_time_units}
\alias{xgx_scale_x_time_units}
\title{Convert time units for plotting}
\usage{
xgx_scale_x_time_units(units_dataset, units_plot = NULL, breaks = NULL,
  labels = NULL, ...)
}
\arguments{
\item{units_dataset}{units of the input dataset, must be specified by user 
as "h", "d", "w", "m", or "y"}

\item{units_plot}{units of the plot, will be units of the dataset if empty}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}

\item{...}{other parameters for 
\code{\link[ggplot2:scale_continuous]{scale_x_continuous}}}
}
\value{
ggplot2 compatible scale object
}
\description{
\code{xgx_scale_x_time_units} converts x axis scale from one time unit 
to another.  
Supported units include hours, days, weeks, months, and years, which 
can also be called using just the first letter (h, d, w, m, y).
}
\examples{
data <- data.frame(x = 1:1000, y = rnorm(1000))
ggplot2::ggplot(data = data, ggplot2::aes(x = x, y = y)) +
  ggplot2::geom_point() +
  xgx_scale_x_time_units(units_dataset = "hours", units_plot = "weeks")
  
}
