% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_envvar}
\alias{set_envvar}
\title{Set environment variables}
\usage{
set_envvar(vars)
}
\arguments{
\item{vars}{A named character vector of the form \code{c(VARIABLE = VALUE)}.
If any value is \code{NA}, this function will try to unset the variable.}
}
\value{
Old values of the variables (if not set, \code{NA}).
}
\description{
Set environment variables from a named character vector, and return the old
values of the variables, so they could be restored later.
}
\details{
The motivation of this function is that \code{\link{Sys.setenv}()} does not
return the old values of the environment variables, so it is not
straightforward to restore the variables later.
}
\examples{
vars = xfun::set_envvar(c(FOO = "1234"))
Sys.getenv("FOO")
xfun::set_envvar(vars)
Sys.getenv("FOO")
}
