% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectUniformP}
\alias{SelectUniformP}
\title{Selection with uniform probability without replacement.}
\usage{
SelectUniformP(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Number of selected genes. Default: 1.}
}
\value{
The index vector of the selected genes.
}
\description{
\code{SelectUniformP} implements selection
             by choosing a gene with equal probability without 
             replacement.
             Usage:
             \enumerate{
             \item
             To specify mating behavior in crossover operators.
             \item
             For computer experiments without selection pressure.
             }
}
\details{
Selection without replacement guarantees that 
         vectors of different indices are selected.
         A vector of the size of the population is a permutation 
         of indices. This property is needed for the classic 
         variant of differential evolution.
}
\examples{
fit<-sample(10, 15, replace=TRUE)
SelectUniformP(fit, NewlFselectGenes()) 
SelectUniformP(fit, NewlFselectGenes(), length(fit)) 
}
\references{
Price, Kenneth V., Storn, Rainer M. and Lampinen, Jouni A. (2005)
The Differential Evolution Algorithm (Chapter 2), pp. 37-134. 
In: Differential Evolution. A Practical Approach to Global Optimization.
Springer, Berlin.
<doi:10.1007/3-540-31306-0>
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniform}()}
}
\concept{Selection Functions}
