% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectSUS}
\alias{SelectSUS}
\title{Stochastic universal sampling.}
\usage{
SelectSUS(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Number of selected genes. Default: 1.}
}
\value{
The index vector of the selected genes.
}
\description{
\code{SelectSUS} implements selection
     by Baker's stochastic universal sampling method. 
     SUS is a strictly sequential algorithm 
     which has zero bias and minimal spread.
     SUS uses a single random number for each generation.
     See Baker, James E. (1987), p. 16.
}
\examples{
fit<-sample(10, 15, replace=TRUE)
SelectSUS(fit, NewlFselectGenes()) 
SelectSUS(fit, NewlFselectGenes(), length(fit)) 
}
\references{
Baker, James E. (1987):
     Reducing Bias and Inefficiency in the Selection Algorithm.
     In Grefenstette, John J.(Ed.) 
     \emph{Proceedings of the Second International 
     Conference on Genetic Algorithms on Genetic Algorithms}, pp. 14-21.
     (ISBN:978-08058-0158-8)
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniformP}()},
\code{\link{SelectUniform}()}
}
\concept{Selection Functions}
