% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parabola2D.R
\name{Parabola2DFactory}
\alias{Parabola2DFactory}
\title{Factory for a 2-dimensional quadratic parabola.}
\usage{
Parabola2DFactory()
}
\value{
A problem environment represented as a list of functions:
        \itemize{
        \item \code{$name()}: The name of the problem environment.
        \item \code{$bitlength()}: The vector of the number of bits of 
                                   each parameter of the function.
        \item \code{$genelength()}: The number of bits of the gene.
        \item \code{$lb()}: The vector of lower bounds of the parameters.
        \item \code{$ub()}: The vector of upper bounds of the parameters.
        \item \code{$f(parm, gene=0, lF=0)}): The fitness function. 
        }
        Additional elements:
        \itemize{
        \item \code{$describe()}: Print a description of the problem environment to the console.
        \item \code{$solution()}: The solution structure. A named list with \code{minimum}, \code{maximum} and
                                  2 lists of equivalent solutions: \code{minpoints}, \code{maxpoints}. 
        }
}
\description{
This list of functions sets up the problem environment
             for a 2-dimensional
             quadratic parabola.
}
\details{
The factory contains examples of all functions 
         which form the interface of a problem environment to
         the simple genetic algorithm with binary-coded genes
         of package \code{xega}.
}
\examples{
Parabola2D<-Parabola2DFactory()
Parabola2D$f(c(2.2, 1.0))
}
\seealso{
DelayedP, Parabola2DErr

Other Problem Environments: 
\code{\link{DeJongF4Factory}()},
\code{\link{DelayedPFactory}()},
\code{\link{Parabola2DEarlyFactory}()},
\code{\link{Parabola2DErrFactory}()},
\code{\link{envXOR}},
\code{\link{lau15}},
\code{\link{newEnvXOR}()},
\code{\link{newTSP}()}
}
\concept{Problem Environments}
