% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPermMutate.R
\name{xegaPermMutateGenekInversion}
\alias{xegaPermMutateGenekInversion}
\title{Mutate a gene (k random inversions).}
\usage{
xegaPermMutateGenekInversion(gene, lF)
}
\arguments{
\item{gene}{A Permutation.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A Permutation.
}
\description{
\code{xegaPermMutateGenekInversion} performs k random inversions.
             The number of inversions is expontially decaying
             with exponential decay constant \code{lambda}.
}
\details{
The only difference to the order based mutation 
         operator (Syswerda, 1991) is the exponential decay 
         in the number of inversions. 

         \enumerate{
         \item The indices of a random subschedule are extracted.
         \item The subschedule is extracted, permuted, and reinserted.
         }
}
\examples{
gene1<-xegaPermInitGene(lFxegaPermGene)
xegaPermDecodeGene(gene1, lFxegaPermGene)
gene<-xegaPermMutateGenekInversion(gene1, lFxegaPermGene)
xegaPermDecodeGene(gene, lFxegaPermGene)

}
\references{
Syswerda, G. (1991): 
            Schedule Optimization Using Genetic Algorithms.
            In: Davis, L. (Ed.): 
            Handbook of Genetic Algorithms, Chapter 21, pp. 332-349.
            Van Nostrand Reinhold, New York.
}
\seealso{
Other Mutation: 
\code{\link{xegaPermMutateGene2Opt}()},
\code{\link{xegaPermMutateGeneBestGreedy}()},
\code{\link{xegaPermMutateGeneGreedy}()},
\code{\link{xegaPermMutateGeneOrderBased}()},
\code{\link{xegaPermMutateGenekOptLK}()},
\code{\link{xegaPermMutateMix}()}
}
\concept{Mutation}
