% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPermCrossover.R
\name{xegaPermCross2Gene}
\alias{xegaPermCross2Gene}
\title{Position based crossover of 2 genes.}
\usage{
xegaPermCross2Gene(gg1, gg2, lF)
}
\arguments{
\item{gg1}{Permutation.}

\item{gg2}{Permutation.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
List of 2 permutations.
}
\description{
\code{xegaPermCross2Gene} determines 
             a random subschedule of random length.
             
             It copies the random subschedule into a new gene.
             The rest of the positions of the new scheme is filled 
             with the elements of the other gene to complete the
             permutation. This is done for each gene.
}
\examples{
gene1<-xegaPermInitGene(lFxegaPermGene)
gene2<-xegaPermInitGene(lFxegaPermGene)
xegaPermDecodeGene(gene1, lFxegaPermGene)
xegaPermDecodeGene(gene2, lFxegaPermGene)
newgenes<-xegaPermCross2Gene(gene1, gene2)
xegaPermDecodeGene(newgenes[[1]], lFxegaPermGene)
xegaPermDecodeGene(newgenes[[2]], lFxegaPermGene)
}
\references{
Syswerda, G. (1991): 
            Schedule Optimization Using Genetic Algorithms.
            In: Davis, L. (Ed.): 
            Handbook of Genetic Algorithms, Chapter 21, p. 343.
            Van Nostrand Reinhold, New York.
            (ISBN:0-442-00173-8)
}
\seealso{
Other Crossover: 
\code{\link{xegaPermCrossGene}()}
}
\concept{Crossover}
