% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{xQTLanalyze_coloc}
\alias{xQTLanalyze_coloc}
\title{Conduct colocalization analysis with trait genes generated from \code{xQTLanalyze_getTraits}}
\usage{
xQTLanalyze_coloc(
  gwasDF,
  traitGene,
  geneType = "auto",
  genomeVersion = "grch38",
  tissueSiteDetail = "",
  study = "gtex_v8",
  mafThreshold = 0.01,
  population = "EUR",
  gwasSampleNum = 50000,
  method = "coloc",
  token = "9246d2db7917",
  bb.alg = FALSE
)
}
\arguments{
\item{gwasDF}{A data.frame or data.table objectof gwas.}

\item{traitGene}{A gene symbol or a gencode id (versioned).}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{genomeVersion}{"grch38" (default) or "grch37". Note: grch37 will be converted to grch38 automatically.}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{study}{(character) name of studies can be listed using "ebi_study_tissues"}

\item{mafThreshold}{Cutoff of maf to remove rare variants.}

\item{population}{Supported population is consistent with the LDlink, which can be listed using function "LDlinkR::list_pop()"}

\item{gwasSampleNum}{Sample number of GWAS dataset. Default:50000.}

\item{method}{(character) options: "coloc"(default) or "hyprcoloc". Package \code{coloc} or \code{hyprcoloc} is required.}

\item{token}{LDlink provided user token, default = NULL, register for token at https://ldlink.nci.nih.gov/?tab=apiaccess}

\item{bb.alg}{For \code{hyprcoloc}, branch and bound algorithm: TRUE, employ BB algorithm; FALSE, do not. Default: FALSE.}
}
\value{
A list of coloc result and details.
}
\description{
Conduct colocalization analysis with trait genes generated from \code{xQTLanalyze_getTraits}
}
\examples{
\donttest{
url1 <- "http://raw.githubusercontent.com/dingruofan/exampleData/master/gwasDFsub_MMP7.txt"
gwasDF <- data.table::fread(url1)
output <- xQTLanalyze_coloc(gwasDF = gwasDF, traitGene= "MMP7", tissueSiteDetail="Prostate")
}
}
