% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addwmfs.R
\name{addwmfs}
\alias{addwmfs}
\title{Adds wavelet mean field information to a \code{clust} object}
\usage{
addwmfs(obj)
}
\arguments{
\item{obj}{An object of class \code{clust}}
}
\value{
\code{addwmfs} returns another \code{clust} object with \code{wmfs} slot now included. 
If  \code{obj$wmfs} was not NA, the object is returned as is.
}
\description{
When a \code{clust} object is created, the \code{wmfs} slot is NA. This function fills it in.
}
\details{
This function uses the values of \code{scale.min}, \code{scale.max.input}, 
\code{sigma} and \code{f0} stored in \code{obj$methodspecs}. It is possible to create 
a \code{clust} object with bad values for these slots. This function throws an error in that 
case. You can use a correlation-based method for calculating the synchrony matrix and 
still pass values of \code{scale.min}, \code{scale.max.input}, \code{sigma} and \code{f0} 
to \code{clust} (in fact, this happens by default) - they won't be used by \code{clust}, 
but they will be there for later use by \code{addwmfs} and \code{addwpmfs}.
}
\examples{
sig<-matrix(.8,5,5)
diag(sig)<-1
lents<-50
if (requireNamespace("mvtnorm",quietly=TRUE))
{
  dat1<-t(mvtnorm::rmvnorm(lents,mean=rep(0,5),sigma=sig))
  dat2<-t(mvtnorm::rmvnorm(lents,mean=rep(0,5),sigma=sig))
}else
{
  dat1<-t(matrix(rep(rnorm(lents),times=5),lents,5))
  dat2<-t(matrix(rep(rnorm(lents),times=5),lents,5))
}
dat<-rbind(dat1,dat2)
times<-1:lents
dat<-cleandat(dat,times,clev=1)$cdat
coords<-data.frame(Y=rep(0,10),X=1:10)
method<-"coh.sig.fast"
clustobj<-clust(dat,times,coords,method,nsurrogs = 100)
res<-addwmfs(clustobj)

}
\seealso{
\code{\link{clust}}, \code{\link{addwpmfs}}, \code{browseVignettes("wsyn")}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
