% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_fns.R
\name{with_eval}
\alias{with_eval}
\title{Evaluate an expression with a data frame acting as the inner environment.}
\usage{
with_eval(x, expr, env = parent.frame())
}
\arguments{
\item{x}{data.frame to work with}

\item{expr}{logical expression to compute per-row}

\item{env}{environment to work in}
}
\value{
evaluated result
}
\description{
References can be forced to the environment with a .e$ prefix
and forced to the data frame with a .d$ prefix (failure to
lookup returns null). Only works on in-memory data.frames.
Part piping with base R series: \url{http://www.win-vector.com/blog/tag/piping-with-base-r/}.
}
\examples{

Temp <- 90
Ozone_bound <- 100
summary(with_eval(airquality,
            (.d$Temp > .e$Temp) &
              (!is.na(Ozone)) & (Ozone < Ozone_bound)))

}
\seealso{
\code{\link[base]{with}}, \code{\link[base]{within}}
}
