% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_fns.R
\name{subset_rows}
\alias{subset_rows}
\title{Pick a subset of rows, evaluating the subset expression
as if the columns of x were in the evaluation environment.}
\usage{
subset_rows(x, subset, env = parent.frame())
}
\arguments{
\item{x}{data.frame to work with}

\item{subset}{logical expression to compute per-row}

\item{env}{environment to work in}
}
\value{
data.frame that is the specified subset of the rows of x.
}
\description{
References can be forced to the environment with a .e$ prefix
and forced to the data frame with a .d$ prefix (failure to
lookup returns null). Only works on in-memory data.frames.
Part piping with base R series: \url{http://www.win-vector.com/blog/tag/piping-with-base-r/}.
See also \url{http://www.win-vector.com/blog/2018/02/is-r-basesubset-really-that-bad/}.
}
\examples{

Temp <- 90
Ozone_bound <- 100
subset_rows(airquality,
            (.d$Temp > .e$Temp) &
              (!is.na(Ozone)) & (Ozone < Ozone_bound))

}
\seealso{
\code{\link[base]{subset}}
}
