% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atblock.R
\name{beval}
\alias{beval}
\title{Evaluate an expression with \code{(!!name)} and \code{:=} to \code{=} substitution.}
\usage{
beval(...)
}
\arguments{
\item{...}{expression or block to evaluate}
}
\description{
The expression represented by the text of the \code{.}-argument is evaluated in
the current environment will all "\code{(!!name)}" forms replaced by the value of name.
Note: this substitution can only be performed on the right hand side of assignments.
This allows variables to carry the names of other variables into what would
be a non-standard evaluation situation.  This adaption allows some parametric
or standard-evaluation effects in such circumstances.
}
\details{
Note: this method uses string substitution and is willing to substitute in arbitrary content,
please prefer using \code{\link{let}} where applicable.

Notation idea: \url{https://github.com/hadley/dplyr/commit/8f03f835185370626a566e95d268623b20189e07}.
Note: "\code{!!}" is not a no-op, but is a sufficiently uncommon expression I thought we could use it.
}
\examples{


c1 <- 1:5
c2 <- 3:7
col1 <- 'c1'
col2 <- 'c2'
beval(
  res <- (!!col1) + (!!col2)
)
print(res)

# larger example
c3 <- 4:8
terms <- paste(c('c1', 'c2', 'c3'), collapse = ' + ')
print(beval((!!terms)))

}
\seealso{
\code{\link{let}}, \code{\link{ateval}}, \code{\link{seval}}
}
