% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkStrictOrder.R
\name{checkStrictOrder}
\alias{checkStrictOrder}
\title{Check for strict (ascencing or descending) order}
\usage{
checkStrictOrder(dat, invertCount = TRUE)
}
\arguments{
\item{dat}{matrix or data.frame}

\item{invertCount}{(logical)}
}
\value{
matrix with counts of (non-)up pairs, (non-)down pairs, (non-)equal-pairs, if 'invertCount'=TRUE resulting 0 means that all columns are folowing the described characteristics (with variabale col-numbers easier to count)
}
\description{
\code{checkStrictOrder} tests lines of 'dat' (matrix of data.frame) for strict order (ascending, descending or constant), 
each col of data is tested relative to the col on its left.
}
\examples{
set.seed(2005); mat <- matrix(round(runif(40),1),nc=4)
checkStrictOrder(mat); mat[which(checkStrictOrder(mat)[,2]==0),]
}
\seealso{
\code{\link[base]{order}}
}
