% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonredDataFrame.R
\name{nonredDataFrame}
\alias{nonredDataFrame}
\title{Filter for unique elements}
\usage{
nonredDataFrame(
  dataFr,
  useCol = c(pepID = "peptide_id", protID = "accession", seq = "sequence", mod =
    "modifications"),
  sepCollapse = "//",
  callFrom = NULL
)
}
\arguments{
\item{dataFr}{(data.frame) main inpput}

\item{useCol}{(character,length=2) comlumn names of 'dataFr' to use : 1st value designates where redundant values should be gathered; 2nd value designes column of which information should be concatenated}

\item{sepCollapse}{(character) conatenation symbol}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
data.frame of filtered (fewer lines) with additional 2 columns 'nSamePep' (number of redundant entries) and 'concID' (concatenated content)
}
\description{
\code{nonredDataFrame}  filters 'x' (list of char-vectors or char-vector) for elements unique (to 'ref' or if NULL to all 'x') and of character length. 
May be used for different 'accession' for same pep sequence (same 'peptide_id').
Note : made for treating data.frames, may be slightly slower than matrix equivalent
}
\examples{
df1 <- data.frame(cbind(xA=letters[1:5],xB=c("h","h","f","e","f"),xC=LETTERS[1:5])) 
nonredDataFrame(df1,useCol=c("xB","xC")) 
}
\seealso{
\code{\link{combineRedBasedOnCol}}, \code{\link{correctToUnique}}, \code{\link[base]{unique}}
}
