% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtSizeUniq.R
\name{filtSizeUniq}
\alias{filtSizeUniq}
\title{Filter for unique elements}
\usage{
filtSizeUniq(
  lst,
  ref = NULL,
  minSize = 6,
  maxSize = 36,
  filtUnique = TRUE,
  byProt = TRUE,
  inclEmpty = TRUE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{lst}{list of character-vectors or character-vector}

\item{ref}{(character) optional alternative 'reference', if not \code{NULL} used in addition to 'lst' for considering elements of 'lst' as unique}

\item{minSize}{(integer) minimum number of characters, if \code{NULL} set to 0}

\item{maxSize}{(integer) maximum number of characters}

\item{filtUnique}{(logical) if \code{TRUE} return unique-only character-strings}

\item{byProt}{(logical) if \code{TRUE} organize output as list (by names of input, eg protein-names) - if 'lst' was named list}

\item{inclEmpty}{(logical) optional including empty list-elements when all elements have been filtered away - if 'lst' was named list}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
list of filtered input
}
\description{
This function aims to identify and remove duplicated elements in a list and maintain the list-structure in the output. 
\code{filtSizeUniq}  filters 'lst' (list of character-vectors or character-vector) for elements being unique (to 'ref' or if NULL to all 'lst') and of character length. 
In addition, the min- and max- character length may be filtered, too. Eg, in proteomics this helps removing peptide sequences which would not be measured/detected any way.
}
\examples{
filtSizeUniq(list(A="a",B=c("b","bb","c"),D=c("dd","d","ddd","c")),filtUn=TRUE,minSi=NULL)
# input: c and dd are repeated
filtSizeUniq(list(A="a",B=c("b","bb","c"),D=c("dd","d","ddd","c")),ref=c(letters[c(1:26,1:3)],
  "dd","dd","bb","ddd"),filtUn=TRUE,minSi=NULL)  # a,b,c,dd repeated 
}
\seealso{
\code{\link{correctToUnique}}, \code{\link[base]{unique}}, \code{\link[base]{duplicated}}
}
