% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniqCountReport.R
\name{uniqCountReport}
\alias{uniqCountReport}
\title{Report number of unique and redundant elements (optional figure)}
\usage{
uniqCountReport(
  dat,
  frL = NULL,
  plotDispl = FALSE,
  tit = NULL,
  col = NULL,
  radius = 0.9,
  sizeTo = NULL,
  clockwise = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(charcter or numeric vector) main input where number of unique (and redunant) should be determined}

\item{frL}{(logical) optional (re-)introducing results from \code{duplicated} to shorten time of execution}

\item{plotDispl}{(logical) decide if pie-type plot should be produced}

\item{tit}{(character) optional title in plot}

\item{col}{(character) custom colors in pie}

\item{radius}{(numeric) radius passed to  \code{pie}}

\item{sizeTo}{(numeric or charcter) optional reference group for size-population relative adjusting overall surface of pie}

\item{clockwise}{(logical) argument passed to pie}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
vector with counts of n (total), nUnique (wo any repeated), nHasRepeated (first of repeated), nRedundant), optional figure
}
\description{
Make report about number of unique and redundant elements of vector 'dat'.
Note : fairly slow for long vectors !!
}
\examples{
layout(1:2)
uniqCountReport(rep(1:7,1:7),plot=TRUE)
uniqCountReport(rep(1:3,1:3),plot=TRUE,sizeTo=rep(1:7,1:7))      
}
\seealso{
\code{\link{correctToUnique}}, \code{\link[base]{unique}}
}
