% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowNormalize.R
\name{.rowNorm}
\alias{.rowNorm}
\title{Row-normalization procedure on matrix or data.frame 'dat'}
\usage{
.rowNorm(
  dat,
  refLi,
  method,
  proportMode,
  maxFact = 10,
  fact0val = 10,
  retFact = FALSE,
  callFrom = NULL,
  debug = FALSE,
  silent = FALSE
)
}
\arguments{
\item{dat}{(matrix) .. init data, smay be parse matrix with numerous NA}

\item{refLi}{(NULL or numeric) allows to consider only specific lines of 'dat' when determining normalization factors (all data will be normalized)}

\item{method}{(character) may be "mean","median" (plus "NULL","none"); When NULL or 'none' is chosen the input will be returned as is}

\item{proportMode}{(logical) decide if normalization should be done by multiplicative or additive factor}

\item{maxFact}{(numeric, length=2) max normalization factor}

\item{fact0val}{(integer)}

\item{retFact}{(logical)}

\item{callFrom}{(character) This function allows easier tracking of messages produced}

\item{debug}{(logical) additional messages for debugging}

\item{silent}{(logical) suppress messages}
}
\value{
This function returns a matrix of normalized data same dimensions as 'dat'
}
\description{
This function was performs a row-normalization procedure on matrix or data.frame 'dat'
}
\examples{
.rowNorm(matrix(11:31, ncol=3), refLi=1, method="mean", proportMode=TRUE)
}
\seealso{
\code{\link{rowNormalize}}
}
