% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampNoDeMArrayLM.R
\name{sampNoDeMArrayLM}
\alias{sampNoDeMArrayLM}
\title{Locate Sample Index From Index or Name Of Pair-Wise Comparisons in list or MArrayLM-Object}
\usage{
sampNoDeMArrayLM(
  MArrayObj,
  useComp,
  groupSep = "-",
  lstMeans = "means",
  lstP = c("BH", "FDR", "p.value"),
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{MArrayObj}{(list or MArray-object) main input}

\item{useComp}{(character or integer) index or name of pairwise-comparison to be addressed}

\item{groupSep}{(character, length=1) separator for paitr of names}

\item{lstMeans}{(character, length=1) the list element containing the individual sample names, typically the matrix containing the replicate-mean values for each type of sample, the column-names get used}

\item{lstP}{(character, length=1) the list element containing all pairwise comparisons performed, the column-names get used}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This fuction returns a numeric vector (length=2) with index indicating the columns of (replicate) mean-values corresponding to the comparison specified in \code{useComp}
}
\description{
When multiple series of data are tested simultaneaously (eg using \code{moderTestXgrp}), multiple pairwise comparisons get performed. 
This function helps locating the samples, ie mean-columns, corresponding to a specific pairwise comparison.
}
\details{
As main input one gives a list or MArrayLM-object containing testing results contain the pairwise comparisons
and a specific comparison indicated by \code{useComp} to get located in the element of mean-columns (\code{lstMeans}) among all pairwise comparisons.
}
\examples{
grp <- factor(rep(LETTERS[c(3,1,4)],c(2,3,3)))
set.seed(2017); t8 <- matrix(round(rnorm(208*8,10,0.4),2), ncol=8,
  dimnames=list(paste(letters[],rep(1:8,each=26),sep=""), paste(grp,c(1:2,1:3,1:3),sep="")))
test8 <- moderTestXgrp(t8, grp) 
head(test8$p.value)         # all pairwise comparisons available
if(requireNamespace("limma", quietly=TRUE)) {  # need limma installed...
  sampNoDeMArrayLM(test8,1)
  head(test8$means[,sampNoDeMArrayLM(test8,1)])
  head(test8$means[,sampNoDeMArrayLM(test8,"C-D")]) }

}
\seealso{
\code{\link{moderTestXgrp}}, this function gets used eg in \code{\link[wrGraph]{MAplotW}} or \code{\link[wrGraph]{VolcanoPlotW}}
}
